package com.deque.networking.models.devtools.serializable

import com.deque.axe.android.wrappers.TextBoundsInScreen
import com.deque.networking.models.devtools.CalculatedProps


data class AxeView(
    /**
     * A direct copy of the associated Android property encapsulated in an Axe wrapper.
     */
    @JvmField val boundsInScreen: AxeRect,
    /**
     * Direct copy of the associated Java Property.
     */
    @JvmField val className: String?,
    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField val contentDescription: String?,
    /**
     * Whether or not the view would be focused by Assistive Technologies.
     */
    @JvmField val isAccessibilityFocusable: Boolean,
    /**
     * Direct copy of associated Android property.
     */
    @JvmField val isFocusable: Boolean,
    /**
     * Whether or not the view responds to Click actions.
     */
    @JvmField val isClickable: Boolean,
    /**
     * True if view interaction is enabled.
     */
    @JvmField val isEnabled: Boolean,
    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField val isImportantForAccessibility: Boolean,
    /**
     * The Children of this view as AxeView objects.
     */
    @JvmField var children: List<AxeView>,
    /**
     * The AxeView of the Label that is acting as the Name for this View.
     */
    @JvmField
    val labeledBy: AxeView?,

    /**
     * The packageName that the View belongs to.
     * FIXME: Make non transient before a 1.0 release.
     */
    @Transient
    @JvmField val packageName: String? = "",

    /**
     * Direct copy of the associated Android property.
     */
    @Transient
    @JvmField val paneTitle: String? = "",

    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField
    val text: String?,

    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField val viewIdResourceName: String?,

    /**
     * Direct copy of hint text for views where text can be entered.
     */
    @JvmField val hintText: String?,

    /**
     * Direct copy of value.
     */
    @JvmField val value: String?,

    /**
     * True if the view overrides AccessibilityDelegate.
     */
    @JvmField
    val overridesAccessibilityDelegate: Boolean,

    /**
     * True if the view is visible to the user.
     */
    @JvmField val isVisibleToUser: Boolean,

    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField val visibility: Int?,

    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField
    val measuredHeight: Int,

    /**
     * Direct copy of the associated Android Property.
     */
    @JvmField
    val measuredWidth: Int,

    /**
     * Text Color property encapsulated in an Axe wrapper.
     */
    @JvmField
    val textColor: String?,

    /**
     * Direct copy of the associated Android property.
     */
    @JvmField
    val id: Int,

    /**
     * True if the view is a ComposeView or child of a ComposeView.
     */
    @JvmField
    val isComposeView: Boolean = false,

    /**
     * Set of ignored rules.
     */
    @JvmField
    val ignoreRules: Set<String> = setOf(),

    /**
     * List of machine learning identified bounds of text.
     */
    @JvmField
    val mlKitIdentifiedTextAndBoundsInScreen: List<TextBoundsInScreen>?,

    /**
     * A unique Identifier for a given view... conflicts possible but unlikely.
     */
    val axeViewId: String,

    /**
     * Detected Screen Orientation value.
     */
    @JvmField
    val screenOrientation: Int?,

    /**
     * Library of calculated props name, role, state, value.
     */
    @JvmField
    val calculatedProps: CalculatedProps
)