package com.deque.networking.models.devtools.serializable

/**
 * Construct a user info from each property.
 * @param userId The user id from Keycloak.
 * @param groupId The group id from Keycloak that matches the devtools group the user belongs to.
 * @param email The users email from Keycloak.
 * @param displayName The users keycloak username.
 * @param firstName The users first name.
 * @param lastName THe users last name.
 */
data class UserInfo
(
    /**
     * The users Id. This directly maps to the value from the Auth Server.
     */
    @JvmField val userId: String,
    /**
     * A String representing the Division, Organization, Domain or any other group of isolated users.
     * This SHOULD come from the auth server, though we could also generate this and store it.
     */
    @JvmField val groupId: String,
    /**
     * The users email address.
     */
    @JvmField val email: String,
    @JvmField val displayName: String,
    @JvmField val firstName: String,
    @JvmField val lastName: String,
    @JvmField val groupPath: String,
    @JvmField var firstTimeUser: Boolean = true
)