package com.deque.networking.utils

import java.util.UUID

class DistinctId(val userId: String?, val email: String?) {
    private val uuid: UUID

    init {
        val combinedUserIdAndEmail = "${userId}/${email}"
        uuid = if (userId.isNullOrEmpty()) {
            UUID.randomUUID()
        } else {
            UUID.nameUUIDFromBytes(combinedUserIdAndEmail.toByteArray())
        }
    }

    override fun toString(): String = uuid.toString()
}
