package com.deque.networking.interfaces

import com.deque.networking.models.auth.AuthSource
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response


class AuthHeaderInterceptor(private val authSource: AuthSource): Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        val token = authSource.getToken()
        val tokenHeader = authSource.getAuthHeader()

        val originalRequest = chain.request()
        val newRequest: Request = originalRequest.newBuilder()
            .addHeader(tokenHeader, token)
            .build()

        return chain.proceed(newRequest)
    }
}