/*
 * Decompiled with CFR 0.152.
 */
package com.deque.networking.interfaces;

import com.deque.networking.models.auth.AuthSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/deque/networking/interfaces/AuthHeaderInterceptor;", "Lokhttp3/Interceptor;", "authSource", "Lcom/deque/networking/models/auth/AuthSource;", "(Lcom/deque/networking/models/auth/AuthSource;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "axe-devtools-android-results"})
public final class AuthHeaderInterceptor
implements Interceptor {
    @NotNull
    private final AuthSource authSource;

    public AuthHeaderInterceptor(@NotNull AuthSource authSource) {
        Intrinsics.checkNotNullParameter((Object)authSource, (String)"authSource");
        this.authSource = authSource;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        String token = this.authSource.getToken();
        String tokenHeader = this.authSource.getAuthHeader();
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().addHeader(tokenHeader, token).build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"originalRequest.newBuild\u2026ken)\n            .build()");
        Request newRequest = request;
        Response response = chain.proceed(newRequest);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(newRequest)");
        return response;
    }
}

