/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.model.auth.AuthenticationServices;
import com.descope.model.client.Client;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.sdk.auth.impl.EnchantedLinkServiceImpl;
import com.descope.sdk.auth.impl.MagicLinkServiceImpl;
import com.descope.sdk.auth.impl.OAuthServiceImpl;
import com.descope.sdk.auth.impl.OTPServiceImpl;
import com.descope.sdk.auth.impl.PasswordServiceImpl;
import com.descope.sdk.auth.impl.SAMLServiceImpl;
import com.descope.sdk.auth.impl.SSOServiceProviderImpl;
import com.descope.sdk.auth.impl.TOTPServiceImpl;
import com.descope.sdk.auth.impl.WebAuthnServiceImpl;

public final class AuthenticationServiceBuilder {
    public static AuthenticationServices buildServices(Client client) {
        return AuthenticationServices.builder().authService(new AuthenticationServiceImpl(client)).otpService(new OTPServiceImpl(client)).samlService(new SAMLServiceImpl(client)).ssoServiceProvider(new SSOServiceProviderImpl(client)).totpService(new TOTPServiceImpl(client)).oauthService(new OAuthServiceImpl(client)).passwordService(new PasswordServiceImpl(client)).magicLinkService(new MagicLinkServiceImpl(client)).enchantedLinkService(new EnchantedLinkServiceImpl(client)).webAuthnService(new WebAuthnServiceImpl(client)).build();
    }

    private AuthenticationServiceBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

