/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.enums.DeliveryMethod;
import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.auth.UpdateOptions;
import com.descope.model.client.Client;
import com.descope.model.enchantedlink.EmptyResponse;
import com.descope.model.enchantedlink.EnchantedLinkResponse;
import com.descope.model.enchantedlink.EnchantedLinkSessionBody;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.LoginOptions;
import com.descope.model.magiclink.SignUpOptions;
import com.descope.model.magiclink.request.SignInRequest;
import com.descope.model.magiclink.request.SignUpRequest;
import com.descope.model.magiclink.request.UpdateEmailRequest;
import com.descope.model.magiclink.request.VerifyRequest;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.EnchantedLinkService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.utils.JwtUtils;
import com.descope.utils.PatternUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

class EnchantedLinkServiceImpl
extends AuthenticationServiceImpl
implements EnchantedLinkService {
    EnchantedLinkServiceImpl(Client client) {
        super(client);
    }

    @Override
    public EnchantedLinkResponse signIn(String loginId, String uri, String token, LoginOptions loginOptions) throws DescopeException {
        ApiProxy apiProxy;
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI enchantedLink = this.composeEnchantedLinkSignInURL();
        SignInRequest signInRequest = new SignInRequest(uri, loginId, loginOptions);
        if (JwtUtils.isJWTRequired(loginOptions)) {
            if (StringUtils.isBlank((CharSequence)token)) {
                throw ServerCommonException.invalidArgument("token");
            }
            apiProxy = this.getApiProxy(token);
        } else {
            apiProxy = this.getApiProxy();
        }
        return apiProxy.post(enchantedLink, signInRequest, EnchantedLinkResponse.class);
    }

    @Override
    public EnchantedLinkResponse signUp(String loginId, String uri, User user) throws DescopeException {
        return this.signUp(loginId, uri, user, null);
    }

    @Override
    public EnchantedLinkResponse signUp(String loginId, String uri, User user, SignUpOptions signupOptions) throws DescopeException {
        if (user == null) {
            user = new User();
        }
        URI enchantedLinkSignUpURL = this.composeEnchantedLinkSignUpURL();
        SignUpRequest.SignUpRequestBuilder signUpRequestBuilder = SignUpRequest.builder().loginId(loginId).uri(uri).user(user).email(loginId);
        if (StringUtils.isBlank((CharSequence)user.getEmail())) {
            user.setEmail(loginId);
        }
        if (signupOptions != null) {
            signUpRequestBuilder.loginOptions(signupOptions);
        }
        SignUpRequest signUpRequest = signUpRequestBuilder.user(user).build();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(enchantedLinkSignUpURL, signUpRequest, EnchantedLinkResponse.class);
    }

    @Override
    public EnchantedLinkResponse signUpOrIn(String loginId, String uri) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI magicLinkSignUpOrInURL = this.composeEnchantedLinkSignUpOrInURL();
        SignInRequest signInRequest = new SignInRequest(uri, loginId, null);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(magicLinkSignUpOrInURL, signInRequest, EnchantedLinkResponse.class);
    }

    @Override
    public AuthenticationInfo getSession(String pendingRef) throws DescopeException {
        URI getSessionURL = this.composeGetSession();
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(getSessionURL, EnchantedLinkSessionBody.builder().pendingRef(pendingRef).build(), JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public void verify(String token) throws DescopeException {
        URI verifyEnchantedLinkURL = this.composeVerifyEnchantedLinkURL();
        VerifyRequest verifyRequest = new VerifyRequest(token);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(verifyEnchantedLinkURL, verifyRequest, EmptyResponse.class);
    }

    @Override
    public EnchantedLinkResponse updateUserEmail(String loginId, String email, String uri, String refreshToken, UpdateOptions updateOptions) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)email) || !PatternUtils.EMAIL_PATTERN.matcher(email).matches()) {
            throw ServerCommonException.invalidArgument("Email");
        }
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.invalidArgument("Refresh Token");
        }
        URI magicLinkUpdateUserEmail = this.composeUpdateUserEmailEnchantedLink();
        if (updateOptions == null) {
            updateOptions = new UpdateOptions();
        }
        UpdateEmailRequest updateEmailRequest = UpdateEmailRequest.builder().email(email).uri(uri).loginId(loginId).crossDevice(false).addToLoginIds(updateOptions.isAddToLoginIds()).onMergeUseExisting(updateOptions.isOnMergeUseExisting()).build();
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        return apiProxy.post(magicLinkUpdateUserEmail, updateEmailRequest, EnchantedLinkResponse.class);
    }

    private URI composeUpdateUserEmailEnchantedLink() {
        return this.getUri("/v1/auth/enchantedlink/update/email");
    }

    private URI composeEnchantedLinkSignInURL() {
        return this.composeURI("/v1/auth/enchantedlink/signin", DeliveryMethod.EMAIL.getValue());
    }

    private URI composeEnchantedLinkSignUpURL() {
        return this.composeURI("/v1/auth/enchantedlink/signup", DeliveryMethod.EMAIL.getValue());
    }

    private URI composeEnchantedLinkSignUpOrInURL() {
        return this.composeURI("/v1/auth/enchantedlink/signup-in", DeliveryMethod.EMAIL.getValue());
    }

    private URI composeVerifyEnchantedLinkURL() {
        return this.getUri("/v1/auth/enchantedlink/verify");
    }

    private URI composeGetSession() {
        return this.getUri("/v1/auth/enchantedlink/pending-session");
    }
}

