/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.enums.DeliveryMethod;
import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.auth.UpdateOptions;
import com.descope.model.client.Client;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.LoginOptions;
import com.descope.model.magiclink.SignUpOptions;
import com.descope.model.magiclink.request.SignInRequest;
import com.descope.model.magiclink.request.SignUpRequest;
import com.descope.model.magiclink.request.UpdateEmailRequest;
import com.descope.model.magiclink.request.UpdatePhoneRequest;
import com.descope.model.magiclink.request.VerifyRequest;
import com.descope.model.magiclink.response.Masked;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.MagicLinkService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.utils.JwtUtils;
import com.descope.utils.PatternUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

class MagicLinkServiceImpl
extends AuthenticationServiceImpl
implements MagicLinkService {
    MagicLinkServiceImpl(Client client) {
        super(client);
    }

    @Override
    public String signIn(DeliveryMethod deliveryMethod, String loginId, String uri, String token, LoginOptions loginOptions) throws DescopeException {
        ApiProxy apiProxy;
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(deliveryMethod);
        URI magicLinkSignInURL = this.composeMagicLinkSignInURI(deliveryMethod);
        SignInRequest signInRequest = new SignInRequest(uri, loginId, loginOptions);
        if (JwtUtils.isJWTRequired(loginOptions)) {
            if (StringUtils.isBlank((CharSequence)token)) {
                throw ServerCommonException.invalidArgument("token");
            }
            apiProxy = this.getApiProxy(token);
        } else {
            apiProxy = this.getApiProxy();
        }
        Masked masked = apiProxy.post(magicLinkSignInURL, signInRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public String signUp(DeliveryMethod deliveryMethod, String loginId, String uri, User user) {
        return this.signUp(deliveryMethod, loginId, uri, user, null);
    }

    @Override
    public String signUp(DeliveryMethod deliveryMethod, String loginId, String uri, User user, SignUpOptions signupOptions) throws DescopeException {
        if (user == null) {
            user = new User();
        }
        this.verifyDeliveryMethod(deliveryMethod, loginId, user);
        Class<? extends Masked> maskedClass = this.getMaskedValue(deliveryMethod);
        URI magicLinkSignUpURL = this.composeMagicLinkSignUpURI(deliveryMethod);
        SignUpRequest.SignUpRequestBuilder signUpRequestBuilder = SignUpRequest.builder().loginId(loginId).uri(uri);
        if (DeliveryMethod.EMAIL.equals((Object)deliveryMethod)) {
            signUpRequestBuilder.email(user.getEmail());
        }
        if (signupOptions != null) {
            signUpRequestBuilder.loginOptions(signupOptions);
        }
        SignUpRequest signUpRequest = signUpRequestBuilder.user(user).build();
        ApiProxy apiProxy = this.getApiProxy();
        Masked masked = apiProxy.post(magicLinkSignUpURL, signUpRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public AuthenticationInfo verify(String token) {
        URI verifyMagicLinkURL = this.composeVerifyMagicLinkURL();
        VerifyRequest verifyRequest = new VerifyRequest(token);
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(verifyMagicLinkURL, verifyRequest, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public String signUpOrIn(DeliveryMethod deliveryMethod, String loginId, String uri) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(deliveryMethod);
        URI magicLinkSignUpOrInURL = this.composeMagicLinkSignUpOrInURI(deliveryMethod);
        SignInRequest signInRequest = new SignInRequest(uri, loginId, null);
        ApiProxy apiProxy = this.getApiProxy();
        Masked masked = apiProxy.post(magicLinkSignUpOrInURL, signInRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public String updateUserEmail(String loginId, String email, String uri, String refreshToken, UpdateOptions updateOptions) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)email) || !PatternUtils.EMAIL_PATTERN.matcher(email).matches()) {
            throw ServerCommonException.invalidArgument("Email");
        }
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.invalidArgument("Refresh Token");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(DeliveryMethod.EMAIL);
        URI magicLinkUpdateUserEmail = this.composeUpdateUserEmailMagiclink();
        if (updateOptions == null) {
            updateOptions = new UpdateOptions();
        }
        UpdateEmailRequest updateEmailRequest = UpdateEmailRequest.builder().email(email).uri(uri).loginId(loginId).crossDevice(false).addToLoginIds(updateOptions.isAddToLoginIds()).onMergeUseExisting(updateOptions.isOnMergeUseExisting()).build();
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        Masked masked = apiProxy.post(magicLinkUpdateUserEmail, updateEmailRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public String updateUserPhone(DeliveryMethod deliveryMethod, String loginId, String phone, String uri, String refreshToken, UpdateOptions updateOptions) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)phone) || !PatternUtils.PHONE_PATTERN.matcher(phone).matches()) {
            throw ServerCommonException.invalidArgument("Phone");
        }
        if (deliveryMethod != DeliveryMethod.WHATSAPP && deliveryMethod != DeliveryMethod.SMS) {
            throw ServerCommonException.invalidArgument("Method");
        }
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.invalidArgument("Refresh Token");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(DeliveryMethod.SMS);
        URI magicLinkUpdateUserPhone = this.composeUpdateUserPhoneMagiclink(deliveryMethod);
        if (updateOptions == null) {
            updateOptions = new UpdateOptions();
        }
        UpdatePhoneRequest updatePhoneRequest = UpdatePhoneRequest.builder().phone(phone).uri(uri).loginId(loginId).crossDevice(false).addToLoginIds(updateOptions.isAddToLoginIds()).onMergeUseExisting(updateOptions.isOnMergeUseExisting()).build();
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        Masked masked = apiProxy.post(magicLinkUpdateUserPhone, updatePhoneRequest, maskedClass);
        return masked.getMasked();
    }

    private URI composeMagicLinkSignInURI(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/magiclink/signin", deliveryMethod.getValue());
    }

    private URI composeMagicLinkSignUpURI(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/magiclink/signup", deliveryMethod.getValue());
    }

    private URI composeVerifyMagicLinkURL() {
        return this.getUri("/v1/auth/magiclink/verify");
    }

    private URI composeMagicLinkSignUpOrInURI(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/magiclink/signup-in", deliveryMethod.getValue());
    }

    private URI composeUpdateUserEmailMagiclink() {
        return this.getUri("/v1/auth/magiclink/update/email");
    }

    private URI composeUpdateUserPhoneMagiclink(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/magiclink/update/phone", deliveryMethod.getValue());
    }
}

