/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.LoginOptions;
import com.descope.model.user.User;
import com.descope.model.webauthn.WebAuthnFinishRequest;
import com.descope.model.webauthn.WebAuthnTransactionResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.WebAuthnService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.utils.CollectionUtils;
import com.descope.utils.JwtUtils;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WebAuthnServiceImpl
extends AuthenticationServiceImpl
implements WebAuthnService {
    WebAuthnServiceImpl(Client client) {
        super(client);
    }

    @Override
    public WebAuthnTransactionResponse signUpStart(String loginId, User user, String origin) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)origin)) {
            throw ServerCommonException.invalidArgument("Origin");
        }
        if (user == null) {
            user = new User();
        }
        URI webAuthnSignUpURL = this.getUri("/v1/auth/webauthn/signup/start");
        Map<String, String> signUpRequest = CollectionUtils.mapOf("loginId", loginId, "user", user, "origin", origin);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(webAuthnSignUpURL, signUpRequest, WebAuthnTransactionResponse.class);
    }

    @Override
    public AuthenticationInfo signUpFinish(WebAuthnFinishRequest finishRequest) throws DescopeException {
        if (finishRequest == null || StringUtils.isBlank((CharSequence)finishRequest.getResponse()) || StringUtils.isBlank((CharSequence)finishRequest.getTransactionId())) {
            throw ServerCommonException.invalidArgument("Finish Request");
        }
        URI webAuthnSignUpURL = this.getUri("/v1/auth/webauthn/signup/finish");
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(webAuthnSignUpURL, finishRequest, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public WebAuthnTransactionResponse signInStart(String loginId, String origin, String token, LoginOptions loginOptions) throws DescopeException {
        ApiProxy apiProxy;
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)origin)) {
            throw ServerCommonException.invalidArgument("Origin");
        }
        if (JwtUtils.isJWTRequired(loginOptions)) {
            if (StringUtils.isBlank((CharSequence)token)) {
                throw ServerCommonException.invalidArgument("Token");
            }
            apiProxy = this.getApiProxy(token);
        } else {
            apiProxy = this.getApiProxy();
        }
        URI webAuthnSignInURL = this.getUri("/v1/auth/webauthn/signin/start");
        Map<String, String> signInRequest = CollectionUtils.mapOf("loginId", loginId, "origin", origin);
        if (loginOptions != null) {
            signInRequest.put("loginOptions", (String)((Object)loginOptions));
        }
        return apiProxy.post(webAuthnSignInURL, signInRequest, WebAuthnTransactionResponse.class);
    }

    @Override
    public AuthenticationInfo signInFinish(WebAuthnFinishRequest finishRequest) throws DescopeException {
        if (finishRequest == null || StringUtils.isBlank((CharSequence)finishRequest.getResponse()) || StringUtils.isBlank((CharSequence)finishRequest.getTransactionId())) {
            throw ServerCommonException.invalidArgument("Finish Request");
        }
        URI webAuthnSignInURL = this.getUri("/v1/auth/webauthn/signin/finish");
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(webAuthnSignInURL, finishRequest, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public WebAuthnTransactionResponse signUpOrInStart(String loginId, String origin) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)origin)) {
            throw ServerCommonException.invalidArgument("Origin");
        }
        URI webAuthnSignUpOrInURL = this.getUri("/v1/auth/webauthn/signup-in/start");
        Map<String, String> signUpOrInRequest = CollectionUtils.mapOf("loginId", loginId, "origin", origin);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(webAuthnSignUpOrInURL, signUpOrInRequest, WebAuthnTransactionResponse.class);
    }

    @Override
    public WebAuthnTransactionResponse updateUserDeviceStart(String loginId, String origin, String token) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)origin)) {
            throw ServerCommonException.invalidArgument("Origin");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            throw ServerCommonException.invalidArgument("Token");
        }
        this.validateSessionWithToken(token);
        URI webAuthnUpdateStartURL = this.getUri("/v1/auth/webauthn/update/start");
        Map<String, String> updateRequest = CollectionUtils.mapOf("loginId", loginId, "origin", origin);
        ApiProxy apiProxy = this.getApiProxy(token);
        return apiProxy.post(webAuthnUpdateStartURL, updateRequest, WebAuthnTransactionResponse.class);
    }

    @Override
    public void updateUserDeviceFinish(WebAuthnFinishRequest finishRequest) throws DescopeException {
        if (finishRequest == null || StringUtils.isBlank((CharSequence)finishRequest.getResponse()) || StringUtils.isBlank((CharSequence)finishRequest.getTransactionId())) {
            throw ServerCommonException.invalidArgument("Finish Request");
        }
        URI webAuthnUpdateFinishURL = this.getUri("/v1/auth/webauthn/update/finish");
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(webAuthnUpdateFinishURL, finishRequest, Void.class);
    }
}

