/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.audit.AuditRecord;
import com.descope.model.audit.AuditSearchRequest;
import com.descope.model.audit.AuditSearchResponse;
import com.descope.model.client.Client;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.AuditService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class AuditServiceImpl
extends ManagementsBase
implements AuditService {
    AuditServiceImpl(Client client) {
        super(client);
    }

    @Override
    public AuditSearchResponse search(AuditSearchRequest request) throws DescopeException {
        if (request == null) {
            request = new AuditSearchRequest();
        }
        Instant now = Instant.now();
        Instant oldest = now.minus(Duration.ofDays(30L));
        if (request.getFrom() != null && request.getFrom().isBefore(oldest)) {
            throw ServerCommonException.invalidArgument("from");
        }
        if (request.getTo() != null && now.isBefore(request.getTo())) {
            throw ServerCommonException.invalidArgument("to");
        }
        URI composeSearchUri = this.composeSearchUri();
        ApiProxy apiProxy = this.getApiProxy();
        ActualAuditSearchRequest actualReq = new ActualAuditSearchRequest(request.getUserIds(), request.getActions(), request.getExcludedActions(), request.getDevices(), request.getMethods(), request.getGeos(), request.getRemoteAddresses(), request.getLoginIds(), request.getTenants(), request.isNoTenants(), request.getText(), request.getFrom() != null ? request.getFrom().toEpochMilli() : 0L, request.getTo() != null ? request.getTo().toEpochMilli() : 0L);
        ActualAuditSearchResponse resp = apiProxy.post(composeSearchUri, actualReq, ActualAuditSearchResponse.class);
        ArrayList<AuditRecord> res = new ArrayList<AuditRecord>();
        for (ActualAuditRecord auditRecord : resp.getAudits()) {
            res.add(new AuditRecord(auditRecord.projectId, auditRecord.userId, auditRecord.action, Instant.ofEpochMilli(auditRecord.occurred != null ? Long.parseLong(auditRecord.occurred) : 0L), auditRecord.device, auditRecord.method, auditRecord.geo, auditRecord.remoteAddress, auditRecord.externalIds, auditRecord.tenants, auditRecord.data));
        }
        return new AuditSearchResponse(res);
    }

    private URI composeSearchUri() {
        return this.getUri("/v1/mgmt/audit/search");
    }

    static class ActualAuditSearchResponse {
        List<ActualAuditRecord> audits;

        public List<ActualAuditRecord> getAudits() {
            return this.audits;
        }

        public void setAudits(List<ActualAuditRecord> audits) {
            this.audits = audits;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActualAuditSearchResponse)) {
                return false;
            }
            ActualAuditSearchResponse other = (ActualAuditSearchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ActualAuditRecord> this$audits = this.getAudits();
            List<ActualAuditRecord> other$audits = other.getAudits();
            return !(this$audits == null ? other$audits != null : !((Object)this$audits).equals(other$audits));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActualAuditSearchResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ActualAuditRecord> $audits = this.getAudits();
            result = result * 59 + ($audits == null ? 43 : ((Object)$audits).hashCode());
            return result;
        }

        public String toString() {
            return "AuditServiceImpl.ActualAuditSearchResponse(audits=" + this.getAudits() + ")";
        }

        public ActualAuditSearchResponse() {
        }

        public ActualAuditSearchResponse(List<ActualAuditRecord> audits) {
            this.audits = audits;
        }
    }

    static class ActualAuditRecord {
        String projectId;
        String userId;
        String action;
        String occurred;
        String device;
        String method;
        String geo;
        String remoteAddress;
        List<String> externalIds;
        List<String> tenants;
        Map<String, Object> data;

        public String getProjectId() {
            return this.projectId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getAction() {
            return this.action;
        }

        public String getOccurred() {
            return this.occurred;
        }

        public String getDevice() {
            return this.device;
        }

        public String getMethod() {
            return this.method;
        }

        public String getGeo() {
            return this.geo;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public List<String> getExternalIds() {
            return this.externalIds;
        }

        public List<String> getTenants() {
            return this.tenants;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setOccurred(String occurred) {
            this.occurred = occurred;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setGeo(String geo) {
            this.geo = geo;
        }

        public void setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public void setExternalIds(List<String> externalIds) {
            this.externalIds = externalIds;
        }

        public void setTenants(List<String> tenants) {
            this.tenants = tenants;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActualAuditRecord)) {
                return false;
            }
            ActualAuditRecord other = (ActualAuditRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$occurred = this.getOccurred();
            String other$occurred = other.getOccurred();
            if (this$occurred == null ? other$occurred != null : !this$occurred.equals(other$occurred)) {
                return false;
            }
            String this$device = this.getDevice();
            String other$device = other.getDevice();
            if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$geo = this.getGeo();
            String other$geo = other.getGeo();
            if (this$geo == null ? other$geo != null : !this$geo.equals(other$geo)) {
                return false;
            }
            String this$remoteAddress = this.getRemoteAddress();
            String other$remoteAddress = other.getRemoteAddress();
            if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
                return false;
            }
            List<String> this$externalIds = this.getExternalIds();
            List<String> other$externalIds = other.getExternalIds();
            if (this$externalIds == null ? other$externalIds != null : !((Object)this$externalIds).equals(other$externalIds)) {
                return false;
            }
            List<String> this$tenants = this.getTenants();
            List<String> other$tenants = other.getTenants();
            if (this$tenants == null ? other$tenants != null : !((Object)this$tenants).equals(other$tenants)) {
                return false;
            }
            Map<String, Object> this$data = this.getData();
            Map<String, Object> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActualAuditRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $occurred = this.getOccurred();
            result = result * 59 + ($occurred == null ? 43 : $occurred.hashCode());
            String $device = this.getDevice();
            result = result * 59 + ($device == null ? 43 : $device.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $geo = this.getGeo();
            result = result * 59 + ($geo == null ? 43 : $geo.hashCode());
            String $remoteAddress = this.getRemoteAddress();
            result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
            List<String> $externalIds = this.getExternalIds();
            result = result * 59 + ($externalIds == null ? 43 : ((Object)$externalIds).hashCode());
            List<String> $tenants = this.getTenants();
            result = result * 59 + ($tenants == null ? 43 : ((Object)$tenants).hashCode());
            Map<String, Object> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "AuditServiceImpl.ActualAuditRecord(projectId=" + this.getProjectId() + ", userId=" + this.getUserId() + ", action=" + this.getAction() + ", occurred=" + this.getOccurred() + ", device=" + this.getDevice() + ", method=" + this.getMethod() + ", geo=" + this.getGeo() + ", remoteAddress=" + this.getRemoteAddress() + ", externalIds=" + this.getExternalIds() + ", tenants=" + this.getTenants() + ", data=" + this.getData() + ")";
        }

        public ActualAuditRecord() {
        }

        public ActualAuditRecord(String projectId, String userId, String action, String occurred, String device, String method, String geo, String remoteAddress, List<String> externalIds, List<String> tenants, Map<String, Object> data) {
            this.projectId = projectId;
            this.userId = userId;
            this.action = action;
            this.occurred = occurred;
            this.device = device;
            this.method = method;
            this.geo = geo;
            this.remoteAddress = remoteAddress;
            this.externalIds = externalIds;
            this.tenants = tenants;
            this.data = data;
        }
    }

    static class ActualAuditSearchRequest {
        List<String> userIds;
        List<String> actions;
        List<String> excludedActions;
        List<String> devices;
        List<String> methods;
        List<String> geos;
        List<String> remoteAddresses;
        List<String> externalIds;
        List<String> tenants;
        boolean noTenants;
        String text;
        long from;
        long to;

        public List<String> getUserIds() {
            return this.userIds;
        }

        public List<String> getActions() {
            return this.actions;
        }

        public List<String> getExcludedActions() {
            return this.excludedActions;
        }

        public List<String> getDevices() {
            return this.devices;
        }

        public List<String> getMethods() {
            return this.methods;
        }

        public List<String> getGeos() {
            return this.geos;
        }

        public List<String> getRemoteAddresses() {
            return this.remoteAddresses;
        }

        public List<String> getExternalIds() {
            return this.externalIds;
        }

        public List<String> getTenants() {
            return this.tenants;
        }

        public boolean isNoTenants() {
            return this.noTenants;
        }

        public String getText() {
            return this.text;
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }

        public void setUserIds(List<String> userIds) {
            this.userIds = userIds;
        }

        public void setActions(List<String> actions) {
            this.actions = actions;
        }

        public void setExcludedActions(List<String> excludedActions) {
            this.excludedActions = excludedActions;
        }

        public void setDevices(List<String> devices) {
            this.devices = devices;
        }

        public void setMethods(List<String> methods) {
            this.methods = methods;
        }

        public void setGeos(List<String> geos) {
            this.geos = geos;
        }

        public void setRemoteAddresses(List<String> remoteAddresses) {
            this.remoteAddresses = remoteAddresses;
        }

        public void setExternalIds(List<String> externalIds) {
            this.externalIds = externalIds;
        }

        public void setTenants(List<String> tenants) {
            this.tenants = tenants;
        }

        public void setNoTenants(boolean noTenants) {
            this.noTenants = noTenants;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setFrom(long from) {
            this.from = from;
        }

        public void setTo(long to) {
            this.to = to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActualAuditSearchRequest)) {
                return false;
            }
            ActualAuditSearchRequest other = (ActualAuditSearchRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNoTenants() != other.isNoTenants()) {
                return false;
            }
            if (this.getFrom() != other.getFrom()) {
                return false;
            }
            if (this.getTo() != other.getTo()) {
                return false;
            }
            List<String> this$userIds = this.getUserIds();
            List<String> other$userIds = other.getUserIds();
            if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
                return false;
            }
            List<String> this$actions = this.getActions();
            List<String> other$actions = other.getActions();
            if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
                return false;
            }
            List<String> this$excludedActions = this.getExcludedActions();
            List<String> other$excludedActions = other.getExcludedActions();
            if (this$excludedActions == null ? other$excludedActions != null : !((Object)this$excludedActions).equals(other$excludedActions)) {
                return false;
            }
            List<String> this$devices = this.getDevices();
            List<String> other$devices = other.getDevices();
            if (this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices)) {
                return false;
            }
            List<String> this$methods = this.getMethods();
            List<String> other$methods = other.getMethods();
            if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
                return false;
            }
            List<String> this$geos = this.getGeos();
            List<String> other$geos = other.getGeos();
            if (this$geos == null ? other$geos != null : !((Object)this$geos).equals(other$geos)) {
                return false;
            }
            List<String> this$remoteAddresses = this.getRemoteAddresses();
            List<String> other$remoteAddresses = other.getRemoteAddresses();
            if (this$remoteAddresses == null ? other$remoteAddresses != null : !((Object)this$remoteAddresses).equals(other$remoteAddresses)) {
                return false;
            }
            List<String> this$externalIds = this.getExternalIds();
            List<String> other$externalIds = other.getExternalIds();
            if (this$externalIds == null ? other$externalIds != null : !((Object)this$externalIds).equals(other$externalIds)) {
                return false;
            }
            List<String> this$tenants = this.getTenants();
            List<String> other$tenants = other.getTenants();
            if (this$tenants == null ? other$tenants != null : !((Object)this$tenants).equals(other$tenants)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActualAuditSearchRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNoTenants() ? 79 : 97);
            long $from = this.getFrom();
            result = result * 59 + (int)($from >>> 32 ^ $from);
            long $to = this.getTo();
            result = result * 59 + (int)($to >>> 32 ^ $to);
            List<String> $userIds = this.getUserIds();
            result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
            List<String> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            List<String> $excludedActions = this.getExcludedActions();
            result = result * 59 + ($excludedActions == null ? 43 : ((Object)$excludedActions).hashCode());
            List<String> $devices = this.getDevices();
            result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
            List<String> $methods = this.getMethods();
            result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
            List<String> $geos = this.getGeos();
            result = result * 59 + ($geos == null ? 43 : ((Object)$geos).hashCode());
            List<String> $remoteAddresses = this.getRemoteAddresses();
            result = result * 59 + ($remoteAddresses == null ? 43 : ((Object)$remoteAddresses).hashCode());
            List<String> $externalIds = this.getExternalIds();
            result = result * 59 + ($externalIds == null ? 43 : ((Object)$externalIds).hashCode());
            List<String> $tenants = this.getTenants();
            result = result * 59 + ($tenants == null ? 43 : ((Object)$tenants).hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "AuditServiceImpl.ActualAuditSearchRequest(userIds=" + this.getUserIds() + ", actions=" + this.getActions() + ", excludedActions=" + this.getExcludedActions() + ", devices=" + this.getDevices() + ", methods=" + this.getMethods() + ", geos=" + this.getGeos() + ", remoteAddresses=" + this.getRemoteAddresses() + ", externalIds=" + this.getExternalIds() + ", tenants=" + this.getTenants() + ", noTenants=" + this.isNoTenants() + ", text=" + this.getText() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }

        public ActualAuditSearchRequest(List<String> userIds, List<String> actions, List<String> excludedActions, List<String> devices, List<String> methods, List<String> geos, List<String> remoteAddresses, List<String> externalIds, List<String> tenants, boolean noTenants, String text, long from, long to) {
            this.userIds = userIds;
            this.actions = actions;
            this.excludedActions = excludedActions;
            this.devices = devices;
            this.methods = methods;
            this.geos = geos;
            this.remoteAddresses = remoteAddresses;
            this.externalIds = externalIds;
            this.tenants = tenants;
            this.noTenants = noTenants;
            this.text = text;
            this.from = from;
            this.to = to;
        }
    }
}

