/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.roles.RoleResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.RolesService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class RolesServiceImpl
extends ManagementsBase
implements RolesService {
    RolesServiceImpl(Client client) {
        super(client);
    }

    @Override
    public void create(String name, String description, List<String> permissionNames) throws DescopeException {
        this.create(name, "", description, permissionNames);
    }

    @Override
    public void create(String name, String tenantId, String description, List<String> permissionNames) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        Map<String, String> request = CollectionUtils.mapOf("name", name, "description", description, "tenantId", tenantId);
        if (permissionNames != null) {
            request.put("permissionNames", (String)((Object)permissionNames));
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/role/create"), request, Void.class);
    }

    @Override
    public void update(String name, String newName, String description, List<String> permissionNames) throws DescopeException {
        this.update(name, "", newName, description, permissionNames);
    }

    @Override
    public void update(String name, String tenantId, String newName, String description, List<String> permissionNames) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        if (StringUtils.isBlank((CharSequence)newName)) {
            throw ServerCommonException.invalidArgument("NewName");
        }
        Map<String, String> request = CollectionUtils.mapOf("name", name, "newName", newName, "description", description, "permissionNames", permissionNames, "tenantId", tenantId);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/role/update"), request, Void.class);
    }

    @Override
    public void delete(String name) throws DescopeException {
        this.delete(name, "");
    }

    @Override
    public void delete(String name, String tenantId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        Map<String, String> request = CollectionUtils.mapOf("name", name, "tenantId", tenantId);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/role/delete"), request, Void.class);
    }

    @Override
    public RoleResponse loadAll() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getUri("/v1/mgmt/role/all"), RoleResponse.class);
    }
}

