/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.sparkjava.test;

import com.despegar.http.client.DeleteMethod;
import com.despegar.http.client.GetMethod;
import com.despegar.http.client.HeadMethod;
import com.despegar.http.client.HttpClient;
import com.despegar.http.client.HttpClientException;
import com.despegar.http.client.HttpMethod;
import com.despegar.http.client.HttpResponse;
import com.despegar.http.client.OptionsMethod;
import com.despegar.http.client.PatchMethod;
import com.despegar.http.client.PostMethod;
import com.despegar.http.client.PutMethod;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import spark.Spark;
import spark.servlet.SparkApplication;

public class SparkServer<T extends SparkApplication>
extends ExternalResource {
    private Class<T> sparkApplicationClass;
    private T sparkApplication;
    private int port;
    private String protocolHostPort;
    private HttpClient httpClient;

    public SparkServer(Class<T> sparkApplicationClass) {
        this(sparkApplicationClass, 4567);
    }

    public SparkServer(Class<T> sparkApplicationClass, int port) {
        this.sparkApplicationClass = sparkApplicationClass;
        this.port = port;
        this.protocolHostPort = "http://localhost:" + port;
        this.httpClient = new HttpClient(1);
    }

    public T getApplication() {
        return this.sparkApplication;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        Spark.port((int)this.port);
        this.sparkApplication = (SparkApplication)this.sparkApplicationClass.newInstance();
        this.sparkApplication.init();
        Spark.awaitInitialization();
    }

    public GetMethod get(String path, boolean followRedirect) {
        return new GetMethod(this.protocolHostPort + path, followRedirect);
    }

    public PostMethod post(String path, String body, boolean followRedirect) {
        return new PostMethod(this.protocolHostPort + path, body, followRedirect);
    }

    public PutMethod put(String path, String body, boolean followRedirect) {
        return new PutMethod(this.protocolHostPort + path, body, followRedirect);
    }

    public PatchMethod patch(String path, String body, boolean followRedirect) {
        return new PatchMethod(this.protocolHostPort + path, body, followRedirect);
    }

    public DeleteMethod delete(String path, boolean followRedirect) {
        return new DeleteMethod(this.protocolHostPort + path, followRedirect);
    }

    public OptionsMethod options(String path, boolean followRedirect) {
        return new OptionsMethod(this.protocolHostPort + path, followRedirect);
    }

    public HeadMethod head(String path, boolean followRedirect) {
        return new HeadMethod(this.protocolHostPort + path, followRedirect);
    }

    public HttpResponse execute(HttpMethod httpMethod) throws HttpClientException {
        return this.httpClient.execute(httpMethod);
    }

    protected void after() {
        this.sparkApplication.destroy();
        Spark.stop();
    }
}

