/*
 * Decompiled with CFR 0.152.
 */
package com.dev9.listener;

import com.dev9.annotation.ClassDriver;
import com.dev9.annotation.MethodDriver;
import com.dev9.driver.ThreadLocalWebDriver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class SeleniumWebDriver
extends TestListenerAdapter {
    private static final Map<Class, List<ITestNGMethod>> classListMap = new HashMap<Class, List<ITestNGMethod>>();
    private final ThreadLocal<Field> webDriverField = new ThreadLocal();
    private final ThreadLocal<Boolean> isDriverTest = new ThreadLocal<Boolean>(){
        {
            this.set(false);
        }
    };
    private final ThreadLocal<List<String>> excludedMethods = new ThreadLocal();

    public void onStart(ITestContext tc) {
        super.onStart(tc);
        this.setClassListMap(tc);
    }

    public void onTestStart(ITestResult tr) {
        super.onTestStart(tr);
        this.checkForWebDriverField(tr);
        if (this.isDriverTest.get().booleanValue()) {
            this.startDriver(tr);
        }
    }

    public void onTestSuccess(ITestResult tr) {
        super.onTestSuccess(tr);
        this.endDriver(tr);
    }

    public void onTestFailure(ITestResult tr) {
        super.onTestFailure(tr);
        this.endDriver(tr);
    }

    public void onTestSkipped(ITestResult tr) {
        super.onTestSkipped(tr);
        this.endDriver(tr);
    }

    private void startDriver(ITestResult tr) {
        if (this.isDriverTest.get().booleanValue()) {
            if (!this.isTestExcluded(tr)) {
                if (!this.isDriverRunning(tr)) {
                    this.initializeDriver(tr);
                }
            } else {
                this.setDriverNull(tr);
            }
        }
    }

    private void initializeDriver(ITestResult tr) {
        try {
            this.webDriverField.get().set(tr.getInstance(), new ThreadLocalWebDriver(this.getRealTestClass(tr), this.getTestDescription(tr)));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void setDriverFieldAccessible() {
        this.webDriverField.get().setAccessible(true);
    }

    private void endDriver(ITestResult tr) {
        if (this.isClassDriver()) {
            ITestNGMethod current = tr.getMethod();
            Class currentClass = current.getRealClass();
            List<ITestNGMethod> remainingMethods = classListMap.get(currentClass);
            ITestNGMethod foundMethod = null;
            for (ITestNGMethod m : remainingMethods) {
                if (!m.getMethodName().equals(current.getMethodName())) continue;
                foundMethod = m;
                int count = m.getInvocationCount();
                if (count <= 1) continue;
                m.setInvocationCount(count - 1);
                return;
            }
            if (foundMethod != null) {
                remainingMethods.remove(foundMethod);
            }
            if (remainingMethods.size() == 0) {
                this.quitDriver(tr);
            }
        } else {
            this.quitDriver(tr);
        }
    }

    private void quitDriver(ITestResult tr) {
        try {
            WebDriver driver = (WebDriver)this.webDriverField.get().get(tr.getInstance());
            driver.quit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setDriverNull(ITestResult tr) {
        try {
            this.webDriverField.get().set(tr.getInstance(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isTestExcluded(ITestResult tr) {
        return this.excludedMethods.get() != null && this.excludedMethods.get().contains(tr.getMethod().getMethodName());
    }

    private boolean isDriverRunning(ITestResult tr) {
        Field webDriver = this.webDriverField.get();
        if (webDriver == null) {
            return false;
        }
        try {
            WebDriver driver = (WebDriver)webDriver.get(tr.getInstance());
            driver.getTitle();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Class getRealTestClass(ITestResult tr) {
        return tr.getTestClass().getRealClass();
    }

    private void checkForWebDriverField(ITestResult tr) {
        Class testClass = this.getRealTestClass(tr);
        for (Field classField : testClass.getDeclaredFields()) {
            if (classField.isAnnotationPresent(ClassDriver.class)) {
                this.setWebDriverField(classField);
                this.isDriverTest.set(classField.getAnnotation(ClassDriver.class).enabled());
                return;
            }
            if (!classField.isAnnotationPresent(MethodDriver.class)) continue;
            this.setWebDriverField(classField);
            this.isDriverTest.set(classField.getAnnotation(MethodDriver.class).enabled());
            this.excludedMethods.set(Arrays.asList(classField.getAnnotation(MethodDriver.class).excludeMethods()));
            return;
        }
    }

    private void setWebDriverField(Field classField) {
        this.webDriverField.set(classField);
        this.isDriverTest.set(true);
        this.setDriverFieldAccessible();
    }

    private void setClassListMap(ITestContext tc) {
        for (ITestNGMethod m : tc.getAllTestMethods()) {
            Class methodsClass = m.getRealClass();
            List<ITestNGMethod> methods = classListMap.get(methodsClass);
            if (methods == null) {
                methods = new ArrayList<ITestNGMethod>();
            }
            methods.add(m);
            classListMap.put(methodsClass, methods);
        }
    }

    private String getTestDescription(ITestResult tr) {
        String description = tr.getMethod().getDescription();
        return description != null && !description.equals("") ? description : null;
    }

    private boolean isClassDriver() {
        return this.webDriverField.get() != null && this.webDriverField.get().isAnnotationPresent(ClassDriver.class);
    }
}

