/*
 * Decompiled with CFR 0.152.
 */
package com.devahoy.android.shared;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Map;
import java.util.Set;

public class Shared {
    private SharedPreferences mPrefs;
    private SharedPreferences.Editor mEditor;

    public Shared(Context context, String fileName) {
        this.mPrefs = context.getSharedPreferences(fileName, 0);
        this.mEditor = this.mPrefs.edit();
    }

    public void save(String key, boolean value) {
        this.mEditor.putBoolean(key, value);
        this.mEditor.apply();
    }

    public void save(String key, float value) {
        this.mEditor.putFloat(key, value);
        this.mEditor.apply();
    }

    public void save(String key, int value) {
        this.mEditor.putInt(key, value);
        this.mEditor.apply();
    }

    public void save(String key, long value) {
        this.mEditor.putLong(key, value);
        this.mEditor.apply();
    }

    public void save(String key, String value) {
        this.mEditor.putString(key, value);
        this.mEditor.apply();
    }

    public void save(String key, Set<String> value) {
        this.mEditor.putStringSet(key, value);
        this.mEditor.apply();
    }

    public Map<String, ?> getAll() {
        return this.mPrefs.getAll();
    }

    public boolean getBoolean(String key, boolean value) {
        return this.mPrefs.getBoolean(key, value);
    }

    public float getFloat(String key, float value) {
        return this.mPrefs.getFloat(key, value);
    }

    public int getInt(String key, int value) {
        return this.mPrefs.getInt(key, value);
    }

    public long getLong(String key, long value) {
        return this.mPrefs.getLong(key, value);
    }

    public String getString(String key, String value) {
        return this.mPrefs.getString(key, value);
    }

    public Set<String> getStringSet(String key, Set<String> value) {
        return this.mPrefs.getStringSet(key, value);
    }

    public void remove(String key) {
        this.mEditor.remove(key);
        this.mEditor.apply();
    }
}

