/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.audio.ExoAudioPlayer;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.core.state.PlaybackStateListener;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.listener.OnTimelineChangedListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfigBuilder;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u008c\u00012\u00020\u0001:\u0004\u008c\u0001\u008d\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0003\u0010\nJ\u0010\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010$\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010)J\u0012\u0010$\u001a\u00020%2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010*\u001a\u00020%H\u0016J\u000e\u0010+\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0012J\u0010\u0010,\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.J\u0010\u0010/\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u000100J\u0010\u00101\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u000102J\u0010\u00103\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u000104J\u0010\u00105\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u000106J\u0010\u00107\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u000108J\u0010\u00109\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010:J\u0010\u0010;\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010<J\u0010\u0010=\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010>J\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020%H\u0002J\u0011\u0010B\u001a\u00020%2\u0006\u0010C\u001a\u00020DH\u0096\u0001J\u0019\u0010E\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020D2\u0006\u0010F\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010G\u001a\u00020H2\u0006\u0010C\u001a\u00020DH\u0096\u0001J\t\u0010I\u001a\u00020%H\u0096\u0001J\t\u0010J\u001a\u00020%H\u0096\u0001J\t\u0010K\u001a\u00020HH\u0096\u0001J\u0013\u0010L\u001a\u00020%2\b\b\u0001\u0010M\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010N\u001a\u00020%2\u0006\u0010O\u001a\u00020PH\u0096\u0001J\u0011\u0010Q\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0001J\u0011\u0010R\u001a\u00020H2\u0006\u0010S\u001a\u00020TH\u0096\u0001J\u0011\u0010U\u001a\u00020H2\u0006\u0010V\u001a\u00020TH\u0096\u0001J\u0019\u0010W\u001a\u00020%2\u0006\u0010C\u001a\u00020D2\u0006\u0010X\u001a\u00020HH\u0096\u0001J\u0011\u0010Y\u001a\u00020%2\u0006\u0010Z\u001a\u00020\u001aH\u0096\u0001J!\u0010[\u001a\u00020%2\u0006\u0010C\u001a\u00020D2\u0006\u0010F\u001a\u00020\u001a2\u0006\u0010\\\u001a\u00020\u001aH\u0096\u0001J\u0011\u0010]\u001a\u00020%2\u0006\u0010^\u001a\u00020_H\u0096\u0001J\u0011\u0010`\u001a\u00020%2\u0006\u0010a\u001a\u00020\u001aH\u0096\u0001J\t\u0010b\u001a\u00020%H\u0096\u0001J\t\u0010c\u001a\u00020%H\u0096\u0001J\t\u0010d\u001a\u00020HH\u0096\u0001R\u0014\u0010\u0002\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0012\u0010e\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bf\u0010\u001cR \u0010g\u001a\u0010\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020i\u0018\u00010hX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bj\u0010kR\u0014\u0010l\u001a\u00020\u001a8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bm\u0010\u001cR\u0014\u0010n\u001a\u00020\u00128WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bo\u0010\u0014R\u001a\u0010p\u001a\u0004\u0018\u00010qX\u0096\u000f\u00a2\u0006\f\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR\u0012\u0010v\u001a\u00020HX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bv\u0010wR\u0012\u0010x\u001a\u00020TX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\by\u0010zR\u0012\u0010{\u001a\u00020TX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b|\u0010zR\u0012\u0010}\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u007fR\u0016\u0010\u0080\u0001\u001a\u00030\u0081\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001R\u001e\u0010\u0084\u0001\u001a\u00020T8WX\u0096\u000f\u00a2\u0006\u000f\u001a\u0005\b\u0085\u0001\u0010z\"\u0006\b\u0086\u0001\u0010\u0087\u0001R\u0018\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001\u00a8\u0006\u008e\u0001"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer;", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "audioPlayerImpl", "<init>", "(Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "getAudioPlayerImpl", "()Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getListenerMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "overriddenDuration", "", "getOverriddenDuration", "()J", "setOverriddenDuration", "(J)V", "duration", "getDuration", "bufferPercentage", "", "getBufferPercentage", "()I", "value", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "mediaItem", "getMediaItem", "()Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "setMediaItem", "(Lcom/devbrackets/android/exomedia/core/audio/MediaItem;)V", "setMedia", "", "uri", "Landroid/net/Uri;", "mediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "reset", "overrideDuration", "setOnPreparedListener", "listener", "Lcom/devbrackets/android/exomedia/listener/OnPreparedListener;", "setOnCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnCompletionListener;", "setOnBufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "setOnSeekCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnSeekCompletionListener;", "setOnTimelineChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnTimelineChangedListener;", "setOnErrorListener", "Lcom/devbrackets/android/exomedia/listener/OnErrorListener;", "setMetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setAnalyticsListener", "Landroidx/media3/exoplayer/analytics/AnalyticsListener;", "setPlaybackStateListener", "Lcom/devbrackets/android/exomedia/core/state/PlaybackStateListener;", "getPlaybackState", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "onPlaybackEnded", "clearSelectedTracks", "type", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "", "pause", "release", "restart", "seekTo", "milliseconds", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setListenerMux", "setPlaybackPitch", "pitch", "", "setPlaybackSpeed", "speed", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setWakeLevel", "levelAndFlags", "start", "stop", "trackSelectionAvailable", "audioSessionId", "getAudioSessionId", "availableTracks", "", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferedPercent", "getBufferedPercent", "currentPosition", "getCurrentPosition", "drmSessionManagerProvider", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "isPlaying", "()Z", "playbackPitch", "getPlaybackPitch", "()F", "playbackSpeed", "getPlaybackSpeed", "playerConfig", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "Companion", "MuxNotifier", "library_release"})
public class AudioPlayer
implements AudioPlayerApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerApi audioPlayerImpl;
    @NotNull
    private final ListenerMux listenerMux;
    private long overriddenDuration;
    @Nullable
    private MediaItem mediaItem;

    public AudioPlayer(@NotNull AudioPlayerApi audioPlayerImpl) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerImpl, (String)"audioPlayerImpl");
        this.audioPlayerImpl = audioPlayerImpl;
        this.listenerMux = new ListenerMux(new MuxNotifier(), null, 2, null);
        this.overriddenDuration = -1L;
        this.audioPlayerImpl.setListenerMux(this.listenerMux);
    }

    @NotNull
    protected final AudioPlayerApi getAudioPlayerImpl() {
        return this.audioPlayerImpl;
    }

    @NotNull
    protected final ListenerMux getListenerMux() {
        return this.listenerMux;
    }

    protected final long getOverriddenDuration() {
        return this.overriddenDuration;
    }

    protected final void setOverriddenDuration(long l) {
        this.overriddenDuration = l;
    }

    public AudioPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new PlayerConfigBuilder(context).build());
    }

    public AudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(Companion.getPlayerImplementation(config));
    }

    @Override
    public long getDuration() {
        return this.overriddenDuration >= 0L ? this.overriddenDuration : this.audioPlayerImpl.getDuration();
    }

    public final int getBufferPercentage() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Nullable
    public final MediaItem getMediaItem() {
        return this.mediaItem;
    }

    protected final void setMediaItem(@Nullable MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    public final void setMedia(@Nullable Uri uri) {
        MediaItem mediaItem;
        Uri uri2 = uri;
        if (uri2 != null) {
            Uri it = uri2;
            boolean bl = false;
            mediaItem = new MediaItem(it, null);
        } else {
            mediaItem = null;
        }
        MediaItem mediaItem2 = mediaItem;
        this.setMedia(mediaItem2);
    }

    public final void setMedia(@Nullable MediaSource mediaSource) {
        MediaItem mediaItem;
        MediaSource mediaSource2 = mediaSource;
        if (mediaSource2 != null) {
            MediaSource it = mediaSource2;
            boolean bl = false;
            mediaItem = new MediaItem(null, it);
        } else {
            mediaItem = null;
        }
        MediaItem mediaItem2 = mediaItem;
        this.setMedia(mediaItem2);
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        this.audioPlayerImpl.setMedia(mediaItem);
        this.mediaItem = mediaItem;
        this.overrideDuration(-1L);
    }

    @Override
    public void reset() {
        this.stop();
        this.setMedia((MediaItem)null);
        this.audioPlayerImpl.reset();
    }

    public final void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public final void setOnPreparedListener(@Nullable OnPreparedListener listener2) {
        this.listenerMux.setOnPreparedListener(listener2);
    }

    public final void setOnCompletionListener(@Nullable OnCompletionListener listener2) {
        this.listenerMux.setOnCompletionListener(listener2);
    }

    public final void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener2) {
        this.listenerMux.setOnBufferUpdateListener(listener2);
    }

    public final void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener2) {
        this.listenerMux.setOnSeekCompletionListener(listener2);
    }

    public final void setOnTimelineChangedListener(@Nullable OnTimelineChangedListener listener2) {
        this.listenerMux.setOnTimelineChangedListener(listener2);
    }

    public final void setOnErrorListener(@Nullable OnErrorListener listener2) {
        this.listenerMux.setOnErrorListener(listener2);
    }

    public final void setMetadataListener(@Nullable MetadataListener listener2) {
        this.listenerMux.setMetadataListener(listener2);
    }

    public final void setAnalyticsListener(@Nullable AnalyticsListener listener2) {
        this.listenerMux.setAnalyticsListener(listener2);
    }

    public final void setPlaybackStateListener(@Nullable PlaybackStateListener listener2) {
        this.listenerMux.setPlaybackStateListener(listener2);
    }

    @NotNull
    public final PlaybackState getPlaybackState() {
        return this.listenerMux.getPlaybackState();
    }

    private final void onPlaybackEnded() {
        this.pause();
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.audioPlayerImpl.getPlayerConfig();
    }

    @Override
    public boolean isPlaying() {
        return this.audioPlayerImpl.isPlaying();
    }

    @Override
    @IntRange(from=0L)
    public long getCurrentPosition() {
        return this.audioPlayerImpl.getCurrentPosition();
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getBufferedPercent() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.audioPlayerImpl.getWindowInfo();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.audioPlayerImpl.getTimeline();
    }

    @Override
    public int getAudioSessionId() {
        return this.audioPlayerImpl.getAudioSessionId();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.audioPlayerImpl.getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.audioPlayerImpl.getPlaybackPitch();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.audioPlayerImpl.getAvailableTracks();
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getVolume() {
        return this.audioPlayerImpl.getVolume();
    }

    @Override
    public void setVolume(float f) {
        this.audioPlayerImpl.setVolume(f);
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.audioPlayerImpl.getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.audioPlayerImpl.setDrmSessionManagerProvider(drmSessionManagerProvider);
    }

    @Override
    public void start() {
        this.audioPlayerImpl.start();
    }

    @Override
    public void pause() {
        this.audioPlayerImpl.pause();
    }

    @Override
    public void stop() {
        this.audioPlayerImpl.stop();
    }

    @Override
    public boolean restart() {
        return this.audioPlayerImpl.restart();
    }

    @Override
    public void release() {
        this.audioPlayerImpl.release();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.audioPlayerImpl.setPlaybackSpeed(speed);
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        return this.audioPlayerImpl.setPlaybackPitch(pitch);
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.audioPlayerImpl.setAudioAttributes(attributes);
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.audioPlayerImpl.setTrackSelectionParameters(parameters);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return this.audioPlayerImpl.trackSelectionAvailable();
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.audioPlayerImpl.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.audioPlayerImpl.isRendererEnabled(type);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.audioPlayerImpl.seekTo(milliseconds);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.audioPlayerImpl.setWakeLevel(levelAndFlags);
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux) {
        Intrinsics.checkNotNullParameter((Object)listenerMux, (String)"listenerMux");
        this.audioPlayerImpl.setListenerMux(listenerMux);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.audioPlayerImpl.setRepeatMode(repeatMode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer$Companion;", "", "<init>", "()V", "getPlayerImplementation", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AudioPlayerApi getPlayerImplementation(@NotNull PlayerConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return config.getFallbackManager().useFallback() ? config.getFallbackManager().getFallbackAudioPlayer(config) : (AudioPlayerApi)new ExoAudioPlayer(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer$MuxNotifier;", "Lcom/devbrackets/android/exomedia/core/ListenerMux$Notifier;", "<init>", "(Lcom/devbrackets/android/exomedia/AudioPlayer;)V", "onExoPlayerError", "", "exoMediaPlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMediaPlaybackEnded", "library_release"})
    private final class MuxNotifier
    extends ListenerMux.Notifier {
        @Override
        public void onExoPlayerError(@NotNull ExoMediaPlayer exoMediaPlayer, @Nullable Exception e) {
            Intrinsics.checkNotNullParameter((Object)exoMediaPlayer, (String)"exoMediaPlayer");
            AudioPlayer.this.stop();
            exoMediaPlayer.forcePrepare();
        }

        @Override
        public void onMediaPlaybackEnded() {
            AudioPlayer.this.onPlaybackEnded();
        }
    }
}

