/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.renderer.provider;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.OptIn;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.audio.AudioCapabilities;
import androidx.media3.exoplayer.audio.AudioRendererEventListener;
import androidx.media3.exoplayer.audio.DecoderAudioRenderer;
import androidx.media3.exoplayer.audio.MediaCodecAudioRenderer;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.renderer.provider.AbstractRenderProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/devbrackets/android/exomedia/core/renderer/provider/AudioRenderProvider;", "Lcom/devbrackets/android/exomedia/core/renderer/provider/AbstractRenderProvider;", "<init>", "()V", "rendererClasses", "", "", "buildRenderers", "Landroidx/media3/exoplayer/Renderer;", "context", "Landroid/content/Context;", "handler", "Landroid/os/Handler;", "listener", "Landroidx/media3/exoplayer/audio/AudioRendererEventListener;", "buildRenderer", "className", "library_release"})
@OptIn(markerClass={UnstableApi.class})
public class AudioRenderProvider
extends AbstractRenderProvider {
    public AudioRenderProvider() {
        super(RendererType.AUDIO);
    }

    @Override
    @NotNull
    public List<String> rendererClasses() {
        Object[] objectArray = new String[]{"androidx.media3.decoder.ffmpeg.FfmpegAudioRenderer", "androidx.media3.decoder.flac.LibflacAudioRenderer", "androidx.media3.decoder.opus.LibopusAudioRenderer"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<Renderer> buildRenderers(@NotNull Context context, @NotNull Handler handler, @NotNull AudioRendererEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        MediaCodecAudioRenderer initialRenderer = new MediaCodecAudioRenderer(context, MediaCodecSelector.DEFAULT, handler, listener2, AudioCapabilities.getCapabilities((Context)context), new AudioProcessor[0]);
        Renderer[] rendererArray = new Renderer[]{initialRenderer};
        return this.buildRenderers(rendererArray, (Function1<? super String, ? extends Renderer>)((Function1)arg_0 -> AudioRenderProvider.buildRenderers$lambda$0(this, handler, listener2, arg_0)));
    }

    private final Renderer buildRenderer(String className, Handler handler, AudioRendererEventListener listener2) {
        Renderer renderer;
        Class<?> rendererClass = Class.forName(className);
        if (Intrinsics.areEqual(rendererClass, DecoderAudioRenderer.class)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Handler.class), (Object)handler), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(AudioRendererEventListener.class), (Object)listener2), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(new AudioProcessor[0].getClass()), (Object)new AudioProcessor[0])};
            renderer = (Renderer)this.newInstance(rendererClass, pairArray);
        } else {
            Log.w((String)"AudioRenderProvider", (String)("Unsupported audio Renderer class " + rendererClass));
            renderer = null;
        }
        return renderer;
    }

    private static final Renderer buildRenderers$lambda$0(AudioRenderProvider this$0, Handler $handler, AudioRendererEventListener $listener, String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this$0.buildRenderer(className, $handler, $listener);
    }
}

