/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.renderer.provider;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import androidx.media3.exoplayer.video.DecoderVideoRenderer;
import androidx.media3.exoplayer.video.MediaCodecVideoRenderer;
import androidx.media3.exoplayer.video.VideoRendererEventListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.renderer.provider.AbstractRenderProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/devbrackets/android/exomedia/core/renderer/provider/VideoRenderProvider;", "Lcom/devbrackets/android/exomedia/core/renderer/provider/AbstractRenderProvider;", "droppedFrameNotificationAmount", "", "videoJoiningTimeMs", "", "<init>", "(IJ)V", "rendererClasses", "", "", "buildRenderers", "Landroidx/media3/exoplayer/Renderer;", "context", "Landroid/content/Context;", "handler", "Landroid/os/Handler;", "listener", "Landroidx/media3/exoplayer/video/VideoRendererEventListener;", "buildRenderer", "className", "library_release"})
@OptIn(markerClass={UnstableApi.class})
public final class VideoRenderProvider
extends AbstractRenderProvider {
    private final int droppedFrameNotificationAmount;
    private final long videoJoiningTimeMs;

    public VideoRenderProvider(int droppedFrameNotificationAmount, long videoJoiningTimeMs) {
        super(RendererType.VIDEO);
        this.droppedFrameNotificationAmount = droppedFrameNotificationAmount;
        this.videoJoiningTimeMs = videoJoiningTimeMs;
    }

    public /* synthetic */ VideoRenderProvider(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 50;
        }
        if ((n2 & 2) != 0) {
            l = 5000L;
        }
        this(n, l);
    }

    @Override
    @NotNull
    public List<String> rendererClasses() {
        Object[] objectArray = new String[]{"androidx.media3.decoder.av1.Libgav1VideoRenderer", "androidx.media3.decoder.vp9.LibvpxVideoRenderer"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<Renderer> buildRenderers(@NotNull Context context, @NotNull Handler handler, @NotNull VideoRendererEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        MediaCodecVideoRenderer initialRenderer = new MediaCodecVideoRenderer(context, MediaCodecSelector.DEFAULT, this.videoJoiningTimeMs, handler, listener2, this.droppedFrameNotificationAmount);
        Renderer[] rendererArray = new Renderer[]{initialRenderer};
        return this.buildRenderers(rendererArray, (Function1<? super String, ? extends Renderer>)((Function1)arg_0 -> VideoRenderProvider.buildRenderers$lambda$0(this, handler, listener2, arg_0)));
    }

    private final Renderer buildRenderer(String className, Handler handler, VideoRendererEventListener listener2) {
        Renderer renderer;
        Class<?> rendererClass = Class.forName(className);
        if (Intrinsics.areEqual(rendererClass, DecoderVideoRenderer.class)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)this.videoJoiningTimeMs), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Handler.class), (Object)handler), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(VideoRendererEventListener.class), (Object)listener2), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)this.droppedFrameNotificationAmount)};
            renderer = (Renderer)this.newInstance(rendererClass, pairArray);
        } else {
            Log.w((String)"VideoRenderProvider", (String)("Unsupported video Renderer class " + rendererClass));
            renderer = null;
        }
        return renderer;
    }

    private static final Renderer buildRenderers$lambda$0(VideoRenderProvider this$0, Handler $handler, VideoRendererEventListener $listener, String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this$0.buildRenderer(className, $handler, $listener);
    }

    public VideoRenderProvider() {
        this(0, 0L, 3, null);
    }
}

