/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.scale;

import android.graphics.Point;
import android.util.Log;
import android.view.View;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0016\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u001a\u0010\b\u001a\u00020'2\b\b\u0001\u0010*\u001a\u00020\u000b2\b\b\u0001\u0010+\u001a\u00020\u000bJ\u0018\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020!2\b\b\u0001\u0010.\u001a\u00020\u000bJ\u0016\u0010/\u001a\u00020)2\u0006\u0010-\u001a\u00020!2\u0006\u00100\u001a\u00020\u0011J\u0010\u00101\u001a\u00020'2\u0006\u0010-\u001a\u00020!H\u0004J\u0010\u00102\u001a\u00020'2\u0006\u0010-\u001a\u00020!H\u0004J\u0010\u00103\u001a\u00020'2\u0006\u0010-\u001a\u00020!H\u0004J\u0010\u00104\u001a\u00020'2\u0006\u0010-\u001a\u00020!H\u0004J\u0010\u00105\u001a\u00020'2\u0006\u0010-\u001a\u00020!H\u0004J \u00106\u001a\u00020'2\u0006\u0010-\u001a\u00020!2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0004J\b\u0010:\u001a\u00020'H\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8D@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u00118FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006<"}, d2={"Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;", "", "<init>", "()V", "intrinsicVideoSize", "Landroid/graphics/Point;", "getIntrinsicVideoSize", "()Landroid/graphics/Point;", "setIntrinsicVideoSize", "(Landroid/graphics/Point;)V", "currentRotation", "", "getCurrentRotation", "()I", "setCurrentRotation", "(I)V", "currentScaleType", "Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "getCurrentScaleType", "()Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "setCurrentScaleType", "(Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;)V", "requestedRotation", "getRequestedRotation", "()Ljava/lang/Integer;", "setRequestedRotation", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "requestedScaleType", "getRequestedScaleType", "setRequestedScaleType", "requestedModificationView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "getRequestedModificationView", "()Ljava/lang/ref/WeakReference;", "setRequestedModificationView", "(Ljava/lang/ref/WeakReference;)V", "reset", "", "ready", "", "width", "height", "rotate", "view", "rotation", "scale", "scaleType", "applyCenter", "applyCenterCrop", "applyCenterInside", "applyFitCenter", "applyFitXy", "setScale", "xScale", "", "yScale", "applyRequestedModifications", "Companion", "library_release"})
public class MatrixManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Point intrinsicVideoSize = new Point(0, 0);
    @IntRange(from=0L, to=359L)
    private int currentRotation;
    @NotNull
    private ScaleType currentScaleType = ScaleType.FIT_CENTER;
    @Nullable
    private Integer requestedRotation;
    @Nullable
    private ScaleType requestedScaleType;
    @NotNull
    private WeakReference<View> requestedModificationView = new WeakReference<Object>(null);
    @NotNull
    private static final String TAG = "MatrixManager";
    protected static final int QUARTER_ROTATION = 90;

    @NotNull
    protected final Point getIntrinsicVideoSize() {
        return this.intrinsicVideoSize;
    }

    protected final void setIntrinsicVideoSize(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
        this.intrinsicVideoSize = point;
    }

    protected final int getCurrentRotation() {
        Integer n = this.requestedRotation;
        return n != null ? n : this.currentRotation;
    }

    protected final void setCurrentRotation(int n) {
        this.currentRotation = n;
    }

    @NotNull
    public final ScaleType getCurrentScaleType() {
        ScaleType scaleType = this.requestedScaleType;
        if (scaleType == null) {
            scaleType = this.currentScaleType;
        }
        return scaleType;
    }

    public final void setCurrentScaleType(@NotNull ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"<set-?>");
        this.currentScaleType = scaleType;
    }

    @Nullable
    protected final Integer getRequestedRotation() {
        return this.requestedRotation;
    }

    protected final void setRequestedRotation(@Nullable Integer n) {
        this.requestedRotation = n;
    }

    @Nullable
    protected final ScaleType getRequestedScaleType() {
        return this.requestedScaleType;
    }

    protected final void setRequestedScaleType(@Nullable ScaleType scaleType) {
        this.requestedScaleType = scaleType;
    }

    @NotNull
    protected final WeakReference<View> getRequestedModificationView() {
        return this.requestedModificationView;
    }

    protected final void setRequestedModificationView(@NotNull WeakReference<View> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.requestedModificationView = weakReference;
    }

    public final void reset() {
        this.setIntrinsicVideoSize(0, 0);
        this.currentRotation = 0;
    }

    public final boolean ready() {
        return this.intrinsicVideoSize.x > 0 && this.intrinsicVideoSize.y > 0;
    }

    public final void setIntrinsicVideoSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        boolean currentWidthHeightSwapped = this.getCurrentRotation() / 90 % 2 == 1;
        this.intrinsicVideoSize.x = currentWidthHeightSwapped ? height : width;
        int n = this.intrinsicVideoSize.y = currentWidthHeightSwapped ? width : height;
        if (this.ready()) {
            this.applyRequestedModifications();
        }
    }

    public final void rotate(@NotNull View view, @IntRange(from=0L, to=359L) int rotation) {
        boolean currentWidthHeightSwapped;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.ready()) {
            this.requestedRotation = rotation;
            this.requestedModificationView = new WeakReference<View>(view);
            return;
        }
        boolean swapWidthHeight = rotation / 90 % 2 == 1;
        boolean bl = currentWidthHeightSwapped = this.getCurrentRotation() / 90 % 2 == 1;
        if (swapWidthHeight != currentWidthHeightSwapped) {
            int tempX = this.intrinsicVideoSize.x;
            this.intrinsicVideoSize.x = this.intrinsicVideoSize.y;
            this.intrinsicVideoSize.y = tempX;
            this.scale(view, this.getCurrentScaleType());
        }
        this.currentRotation = rotation;
        view.setRotation((float)rotation);
    }

    public final boolean scale(@NotNull View view, @NotNull ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        if (!this.ready()) {
            this.requestedScaleType = scaleType;
            this.requestedModificationView = new WeakReference<View>(view);
            return false;
        }
        if (view.getHeight() == 0 || view.getWidth() == 0) {
            Log.d((String)TAG, (String)("Unable to apply scale with a view size of (" + view.getWidth() + ", " + view.getHeight() + ")"));
            return false;
        }
        this.currentScaleType = scaleType;
        switch (WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: {
                this.applyCenter(view);
                break;
            }
            case 2: {
                this.applyCenterCrop(view);
                break;
            }
            case 3: {
                this.applyCenterInside(view);
                break;
            }
            case 4: {
                this.applyFitCenter(view);
                break;
            }
            case 5: {
                this.applyFitXy(view);
                break;
            }
            case 6: {
                this.setScale(view, 1.0f, 1.0f);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return true;
    }

    protected final void applyCenter(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float xScale = (float)this.intrinsicVideoSize.x / (float)view.getWidth();
        float yScale = (float)this.intrinsicVideoSize.y / (float)view.getHeight();
        this.setScale(view, xScale, yScale);
    }

    protected final void applyCenterCrop(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float xScale = (float)view.getWidth() / (float)this.intrinsicVideoSize.x;
        float yScale = (float)view.getHeight() / (float)this.intrinsicVideoSize.y;
        float scale = Math.max(xScale, yScale);
        xScale = scale / xScale;
        yScale = scale / yScale;
        this.setScale(view, xScale, yScale);
    }

    protected final void applyCenterInside(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.intrinsicVideoSize.x <= view.getWidth() && this.intrinsicVideoSize.y <= view.getHeight()) {
            this.applyCenter(view);
        } else {
            this.applyFitCenter(view);
        }
    }

    protected final void applyFitCenter(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float xScale = (float)view.getWidth() / (float)this.intrinsicVideoSize.x;
        float yScale = (float)view.getHeight() / (float)this.intrinsicVideoSize.y;
        float scale = Math.min(xScale, yScale);
        xScale = scale / xScale;
        yScale = scale / yScale;
        this.setScale(view, xScale, yScale);
    }

    protected final void applyFitXy(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.setScale(view, 1.0f, 1.0f);
    }

    protected final void setScale(@NotNull View view, float xScale, float yScale) {
        boolean currentWidthHeightSwapped;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        boolean bl = currentWidthHeightSwapped = this.getCurrentRotation() / 90 % 2 == 1;
        if (currentWidthHeightSwapped) {
            view.setScaleX(yScale * (float)view.getHeight() / (float)view.getWidth());
            view.setScaleY(xScale * (float)view.getWidth() / (float)view.getHeight());
            return;
        }
        view.setScaleX(xScale);
        view.setScaleY(yScale);
    }

    protected final void applyRequestedModifications() {
        View view = (View)this.requestedModificationView.get();
        if (view != null) {
            View view2 = view;
            boolean bl = false;
            Integer n = this.requestedRotation;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                this.rotate(view2, it);
                this.requestedRotation = null;
            }
            ScaleType scaleType = this.requestedScaleType;
            if (scaleType != null) {
                ScaleType it = scaleType;
                boolean bl3 = false;
                this.scale(view2, it);
                this.requestedScaleType = null;
            }
        }
        this.requestedModificationView = new WeakReference<Object>(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager$Companion;", "", "<init>", "()V", "TAG", "", "QUARTER_ROTATION", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScaleType.values().length];
            try {
                nArray[ScaleType.CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.CENTER_CROP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.CENTER_INSIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.FIT_CENTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.FIT_XY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.NONE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

