/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.fallback.audio;

import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.fallback.FallbackMediaPlayer;
import com.devbrackets.android.exomedia.fallback.FallbackMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010CH\u0016J\b\u0010D\u001a\u00020AH\u0016J\u0012\u0010E\u001a\u00020A2\b\b\u0001\u0010F\u001a\u00020 H\u0016J\b\u0010G\u001a\u00020AH\u0016J\b\u0010H\u001a\u00020AH\u0016J\b\u0010I\u001a\u00020AH\u0016J\b\u0010J\u001a\u00020\u001dH\u0016J\b\u0010K\u001a\u00020AH\u0016J\u0010\u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u0013H\u0016J\u0010\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u0013H\u0016J\u0010\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020A2\u0006\u0010T\u001a\u00020\u000fH\u0016J\b\u0010U\u001a\u00020\u001dH\u0016J\u0010\u0010V\u001a\u00020A2\u0006\u0010W\u001a\u00020XH\u0016J \u0010Y\u001a\u00020A2\u0006\u0010Z\u001a\u0002052\u0006\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020\u000fH\u0016J\u0018\u0010]\u001a\u00020\u000f2\u0006\u0010Z\u001a\u0002052\u0006\u0010[\u001a\u00020\u000fH\u0016J\u0010\u0010^\u001a\u00020A2\u0006\u0010Z\u001a\u000205H\u0016J\u0018\u0010_\u001a\u00020A2\u0006\u0010Z\u001a\u0002052\u0006\u0010`\u001a\u00020\u001dH\u0016J\u0010\u0010a\u001a\u00020\u001d2\u0006\u0010Z\u001a\u000205H\u0016J\u0010\u0010b\u001a\u00020A2\u0006\u0010c\u001a\u00020\rH\u0016J\u0010\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020\u000fH\u0016J\u0018\u0010f\u001a\u00020R2\u0006\u0010g\u001a\u00020\u000f2\u0006\u0010h\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0016\u0010%\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0011R\u0014\u0010/\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0016R\u0014\u00101\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0016R\"\u00103\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000206\u0018\u0001048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R(\u0010;\u001a\u0004\u0018\u00010:2\b\u00109\u001a\u0004\u0018\u00010:8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006i"}, d2={"Lcom/devbrackets/android/exomedia/fallback/audio/NativeAudioPlayer;", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "<init>", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "mediaPlayer", "Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayer;", "getMediaPlayer", "()Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayer;", "mediaPlayer$delegate", "Lkotlin/Lazy;", "_listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "bufferedPercent", "", "getBufferedPercent", "()I", "value", "", "volume", "getVolume", "()F", "setVolume", "(F)V", "playerConfig", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "isPlaying", "", "()Z", "duration", "", "getDuration", "()J", "currentPosition", "getCurrentPosition", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "audioSessionId", "getAudioSessionId", "playbackSpeed", "getPlaybackSpeed", "playbackPitch", "getPlaybackPitch", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "_", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "setMedia", "", "mediaItem", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "reset", "seekTo", "milliseconds", "start", "pause", "stop", "restart", "release", "setPlaybackSpeed", "speed", "setPlaybackPitch", "pitch", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setWakeLevel", "levelAndFlags", "trackSelectionAvailable", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setSelectedTrack", "type", "groupIndex", "trackIndex", "getSelectedTrackIndex", "clearSelectedTracks", "setRendererEnabled", "enabled", "isRendererEnabled", "setListenerMux", "listenerMux", "setRepeatMode", "repeatMode", "getAudioAttributes", "usage", "contentType", "library_release"})
public final class NativeAudioPlayer
implements AudioPlayerApi {
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final Lazy mediaPlayer$delegate;
    @Nullable
    private ListenerMux _listenerMux;
    private final int bufferedPercent;

    public NativeAudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.mediaPlayer$delegate = LazyKt.lazy(() -> NativeAudioPlayer.mediaPlayer_delegate$lambda$1(this));
        this.bufferedPercent = this.getMediaPlayer().getBufferedPercent();
    }

    private final FallbackMediaPlayer getMediaPlayer() {
        Lazy lazy = this.mediaPlayer$delegate;
        return (FallbackMediaPlayer)lazy.getValue();
    }

    @Override
    public int getBufferedPercent() {
        return this.bufferedPercent;
    }

    @Override
    public float getVolume() {
        return this.getMediaPlayer().getVolume();
    }

    @Override
    public void setVolume(float value) {
        this.getMediaPlayer().setVolume(value);
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.config;
    }

    @Override
    public boolean isPlaying() {
        return this.getMediaPlayer().getPlaying();
    }

    @Override
    public long getDuration() {
        return this.getMediaPlayer().getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.getMediaPlayer().getCurrentPosition();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return null;
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.getMediaPlayer().getTimeline();
    }

    @Override
    public int getAudioSessionId() {
        return this.getMediaPlayer().getAudioSessionId();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.getMediaPlayer().getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.getMediaPlayer().getPlaybackPitch();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return null;
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return null;
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        block1: {
            MediaItem mediaItem2 = mediaItem;
            this.getMediaPlayer().setMedia((Uri)(mediaItem2 != null ? mediaItem2.getUri() : null));
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux != null) {
                listenerMux.setNotifiedPrepared(false);
            }
            ListenerMux listenerMux2 = this._listenerMux;
            if (listenerMux2 == null) break block1;
            listenerMux2.setNotifiedCompleted(false);
        }
    }

    @Override
    public void reset() {
        this.getMediaPlayer().reset();
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.getMediaPlayer().seekTo(milliseconds);
    }

    @Override
    public void start() {
        block0: {
            this.getMediaPlayer().start();
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux == null) break block0;
            listenerMux.setNotifiedCompleted(false);
        }
    }

    @Override
    public void pause() {
        this.getMediaPlayer().pause();
    }

    @Override
    public void stop() {
        this.getMediaPlayer().stop();
    }

    @Override
    public boolean restart() {
        block2: {
            if (!this.getMediaPlayer().restart()) {
                return false;
            }
            ListenerMux listenerMux = this._listenerMux;
            if (listenerMux != null) {
                listenerMux.setNotifiedPrepared(false);
            }
            ListenerMux listenerMux2 = this._listenerMux;
            if (listenerMux2 == null) break block2;
            listenerMux2.setNotifiedCompleted(false);
        }
        return true;
    }

    @Override
    public void release() {
        this.getMediaPlayer().release();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        this.getMediaPlayer().setPlaybackSpeed(speed);
        return true;
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        this.getMediaPlayer().setPlaybackPitch(pitch);
        return true;
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.getMediaPlayer().setAudioAttributes(attributes);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.getMediaPlayer().setWakeLevel(levelAndFlags);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return -1;
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return false;
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux) {
        Intrinsics.checkNotNullParameter((Object)listenerMux, (String)"listenerMux");
        this._listenerMux = listenerMux;
        this.getMediaPlayer().setListener(listenerMux);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
    }

    private final AudioAttributes getAudioAttributes(int usage, int contentType) {
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioAttributes, (String)"build(...)");
        return audioAttributes;
    }

    private static final FallbackMediaPlayerImpl mediaPlayer_delegate$lambda$1(NativeAudioPlayer this$0) {
        FallbackMediaPlayerImpl fallbackMediaPlayerImpl;
        FallbackMediaPlayerImpl $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240 = fallbackMediaPlayerImpl = new FallbackMediaPlayerImpl(this$0.config.getContext());
        boolean bl = false;
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setAudioAttributes(this$0.getAudioAttributes(1, 2));
        return fallbackMediaPlayerImpl;
    }
}

