/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp.manager.track;

import android.content.Context;
import android.util.ArrayMap;
import androidx.annotation.OptIn;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.AdaptiveTrackSelection;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.trackselection.MappingTrackSelector;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.nmp.manager.track.RendererTrackInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000eJ\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/devbrackets/android/exomedia/nmp/manager/track/TrackManager;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "selectionFactory", "Landroidx/media3/exoplayer/trackselection/AdaptiveTrackSelection$Factory;", "selector", "Landroidx/media3/exoplayer/trackselection/DefaultTrackSelector;", "getSelector", "()Landroidx/media3/exoplayer/trackselection/DefaultTrackSelector;", "getAvailableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getExoPlayerTracksInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/track/RendererTrackInfo;", "type", "groupIndex", "", "mappedTrackInfo", "Landroidx/media3/exoplayer/trackselection/MappingTrackSelector$MappedTrackInfo;", "setTrackSelectionParameters", "", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "getSelectedTrackIndex", "setSelectedTrack", "trackIndex", "clearSelectedTracks", "setRendererEnabled", "enabled", "", "isRendererEnabled", "library_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nTrackManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackManager.kt\ncom/devbrackets/android/exomedia/nmp/manager/track/TrackManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n13409#2:227\n13410#2:230\n37#3,2:228\n1755#4,3:231\n*S KotlinDebug\n*F\n+ 1 TrackManager.kt\ncom/devbrackets/android/exomedia/nmp/manager/track/TrackManager\n*L\n38#1:227\n38#1:230\n48#1:228,2\n222#1:231,3\n*E\n"})
public final class TrackManager {
    @NotNull
    private final AdaptiveTrackSelection.Factory selectionFactory;
    @NotNull
    private final DefaultTrackSelector selector;

    public TrackManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.selectionFactory = new AdaptiveTrackSelection.Factory();
        this.selector = new DefaultTrackSelector(context, (ExoTrackSelection.Factory)this.selectionFactory);
    }

    @NotNull
    public final DefaultTrackSelector getSelector() {
        return this.selector;
    }

    @Nullable
    public final Map<RendererType, TrackGroupArray> getAvailableTracks() {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return null;
        }
        ArrayMap trackMap = new ArrayMap();
        RendererType[] $this$forEach$iv = RendererType.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RendererType element$iv;
            RendererType type = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ArrayList<TrackGroup> trackGroups = new ArrayList<TrackGroup>();
            Object object = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo).getIndexes().iterator();
            while (object.hasNext()) {
                TrackGroupArray trackGroupArray;
                int exoPlayerTrackIndex = ((Number)object.next()).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)mappedTrackInfo.getTrackGroups(exoPlayerTrackIndex), (String)"getTrackGroups(...)");
                int n2 = trackGroupArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    trackGroups.add(trackGroupArray.get(i2));
                }
            }
            if (!(!((Collection)trackGroups).isEmpty())) continue;
            object = (Map)trackMap;
            Collection $this$toTypedArray$iv = trackGroups;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            TrackGroupArray trackGroupArray = thisCollection$iv.toArray(new TrackGroup[0]);
            trackGroupArray = new TrackGroupArray(Arrays.copyOf(trackGroupArray, ((TrackGroup[])trackGroupArray).length));
            object.put(type, trackGroupArray);
        }
        return (Map)trackMap;
    }

    @NotNull
    public final RendererTrackInfo getExoPlayerTracksInfo(@NotNull RendererType type, int groupIndex, @Nullable MappingTrackSelector.MappedTrackInfo mappedTrackInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (mappedTrackInfo == null) {
            return new RendererTrackInfo(CollectionsKt.emptyList(), -1, -1);
        }
        ArrayList<Integer> rendererTrackIndexes = new ArrayList<Integer>();
        int rendererTrackIndex = -1;
        int rendererTrackGroupIndex = -1;
        int skippedRenderersGroupsCount = 0;
        int n = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < n; ++rendererIndex) {
            TrackGroupArray trackGroups;
            if (type.getExoPlayerTrackType() != mappedTrackInfo.getRendererType(rendererIndex)) continue;
            rendererTrackIndexes.add(rendererIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mappedTrackInfo.getTrackGroups(rendererIndex), (String)"getTrackGroups(...)");
            if (skippedRenderersGroupsCount + trackGroups.length <= groupIndex) {
                skippedRenderersGroupsCount += trackGroups.length;
                continue;
            }
            if (rendererTrackIndex != -1) continue;
            rendererTrackIndex = rendererIndex;
            rendererTrackGroupIndex = groupIndex - skippedRenderersGroupsCount;
        }
        return new RendererTrackInfo((List<Integer>)rendererTrackIndexes, rendererTrackIndex, rendererTrackGroupIndex);
    }

    public final void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.selector.setParameters(parameters);
    }

    @JvmOverloads
    public final int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, groupIndex, mappedTrackInfo);
        if (tracksInfo.getIndex() == -1) {
            return -1;
        }
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo2 = mappedTrackInfo;
        Intrinsics.checkNotNull((Object)mappedTrackInfo2);
        TrackGroupArray trackGroupArray = mappedTrackInfo2.getTrackGroups(tracksInfo.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)trackGroupArray, (String)"getTrackGroups(...)");
        TrackGroupArray trackGroupArray2 = trackGroupArray;
        if (trackGroupArray2.length == 0) {
            return -1;
        }
        DefaultTrackSelector.SelectionOverride selectionOverride = this.selector.getParameters().getSelectionOverride(tracksInfo.getIndex(), trackGroupArray2);
        if (selectionOverride == null || selectionOverride.groupIndex != tracksInfo.getGroupIndex() || selectionOverride.length <= 0) {
            return -1;
        }
        return selectionOverride.tracks[0];
    }

    public static /* synthetic */ int getSelectedTrackIndex$default(TrackManager trackManager, RendererType rendererType, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return trackManager.getSelectedTrackIndex(rendererType, n);
    }

    public final void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, groupIndex, mappedTrackInfo);
        if (tracksInfo.getIndex() == -1 || mappedTrackInfo == null) {
            return;
        }
        TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(tracksInfo.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)trackGroupArray, (String)"getTrackGroups(...)");
        TrackGroupArray trackGroupArray2 = trackGroupArray;
        if (trackGroupArray2.length == 0 || trackGroupArray2.length <= tracksInfo.getGroupIndex()) {
            return;
        }
        TrackGroup trackGroup = trackGroupArray2.get(tracksInfo.getGroupIndex());
        Intrinsics.checkNotNullExpressionValue((Object)trackGroup, (String)"get(...)");
        TrackGroup group = trackGroup;
        if (group.length <= trackIndex) {
            return;
        }
        DefaultTrackSelector.Parameters.Builder builder = this.selector.buildUponParameters();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"buildUponParameters(...)");
        DefaultTrackSelector.Parameters.Builder parametersBuilder = builder;
        Iterator<Integer> iterator = tracksInfo.getIndexes().iterator();
        while (iterator.hasNext()) {
            int rendererTrackIndex = ((Number)iterator.next()).intValue();
            parametersBuilder.clearSelectionOverrides(rendererTrackIndex);
            if (tracksInfo.getIndex() != rendererTrackIndex) {
                parametersBuilder.setRendererDisabled(rendererTrackIndex, true);
                continue;
            }
            int[] nArray = new int[]{trackIndex};
            parametersBuilder.setSelectionOverride(rendererTrackIndex, trackGroupArray2, new DefaultTrackSelector.SelectionOverride(tracksInfo.getGroupIndex(), nArray));
            parametersBuilder.setRendererDisabled(rendererTrackIndex, false);
        }
        this.selector.setParameters(parametersBuilder);
    }

    public final void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        DefaultTrackSelector.Parameters.Builder builder = this.selector.buildUponParameters();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"buildUponParameters(...)");
        DefaultTrackSelector.Parameters.Builder parametersBuilder = builder;
        Iterator<Integer> iterator = tracksInfo.getIndexes().iterator();
        while (iterator.hasNext()) {
            int rendererTrackIndex = ((Number)iterator.next()).intValue();
            parametersBuilder.setRendererDisabled(rendererTrackIndex, false).clearSelectionOverrides(rendererTrackIndex);
        }
        this.selector.setParameters(parametersBuilder);
    }

    public final void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        if (tracksInfo.getIndexes().isEmpty()) {
            return;
        }
        boolean enabledSomething = false;
        DefaultTrackSelector.Parameters.Builder builder = this.selector.buildUponParameters();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"buildUponParameters(...)");
        DefaultTrackSelector.Parameters.Builder parametersBuilder = builder;
        Iterator<Integer> iterator = tracksInfo.getIndexes().iterator();
        while (iterator.hasNext()) {
            int rendererTrackIndex = ((Number)iterator.next()).intValue();
            if (!enabled) {
                parametersBuilder.setRendererDisabled(rendererTrackIndex, true);
                continue;
            }
            DefaultTrackSelector.Parameters parameters = this.selector.getParameters();
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo2 = mappedTrackInfo;
            Intrinsics.checkNotNull((Object)mappedTrackInfo2);
            DefaultTrackSelector.SelectionOverride selectionOverride = parameters.getSelectionOverride(rendererTrackIndex, mappedTrackInfo2.getTrackGroups(rendererTrackIndex));
            if (selectionOverride == null) continue;
            parametersBuilder.setRendererDisabled(rendererTrackIndex, false);
            enabledSomething = true;
        }
        if (enabled && !enabledSomething) {
            parametersBuilder.setRendererDisabled(((Number)tracksInfo.getIndexes().get(0)).intValue(), false);
        }
        this.selector.setParameters(parametersBuilder);
    }

    public final boolean isRendererEnabled(@NotNull RendererType type) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
            RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
            DefaultTrackSelector.Parameters parameters = this.selector.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"getParameters(...)");
            DefaultTrackSelector.Parameters parameters2 = parameters;
            Iterable $this$any$iv = tracksInfo.getIndexes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!(!parameters2.getRendererDisabled(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final int getSelectedTrackIndex(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return TrackManager.getSelectedTrackIndex$default(this, type, 0, 2, null);
    }
}

