/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.attr;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.StyleableRes;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.nmp.config.DefaultPlayerConfigProvider;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfigProvider;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributes;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControlsProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ/\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributeParser;", "", "<init>", "()V", "parse", "Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributes;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "getOrDefault", "T", "Landroid/content/res/TypedArray;", "styleable", "", "default", "Lkotlin/Function0;", "(Landroid/content/res/TypedArray;ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "library_release"})
public final class VideoViewAttributeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOG_TAG = "VideoViewAttrParser";

    @NotNull
    public final VideoViewAttributes parse(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (attrs == null) {
            return new VideoViewAttributes(false, null, false, null, null, 31, null);
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VideoView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        boolean useTextureViewBacking = typedArray2.getBoolean(R.styleable.VideoView_useTextureViewBacking, false);
        ScaleType scaleType = typedArray2.hasValue(R.styleable.VideoView_videoScale) ? ScaleType.Companion.fromOrdinal(typedArray2.getInt(R.styleable.VideoView_videoScale, -1)) : null;
        boolean measureBasedOnAspectRatio = typedArray2.hasValue(R.styleable.VideoView_measureBasedOnAspectRatio) ? typedArray2.getBoolean(R.styleable.VideoView_measureBasedOnAspectRatio, false) : false;
        PlayerConfigProvider configProvider = (PlayerConfigProvider)this.getOrDefault(typedArray2, R.styleable.VideoView_playerConfigProvider, VideoViewAttributeParser::parse$lambda$0);
        VideoControlsProvider controlsProvider = (VideoControlsProvider)this.getOrDefault(typedArray2, R.styleable.VideoView_videoControlsProvider, VideoViewAttributeParser::parse$lambda$1);
        typedArray2.recycle();
        return new VideoViewAttributes(useTextureViewBacking, scaleType, measureBasedOnAspectRatio, configProvider, controlsProvider);
    }

    private final <T> T getOrDefault(TypedArray $this$getOrDefault, @StyleableRes int styleable2, Function0<? extends T> function0) {
        String className = $this$getOrDefault.getString(styleable2);
        Object object = className;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return (T)function0.invoke();
        }
        try {
            object = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Unable to construct class for name " + className), (Throwable)e);
            object = function0.invoke();
        }
        return (T)object;
    }

    private static final DefaultPlayerConfigProvider parse$lambda$0() {
        return new DefaultPlayerConfigProvider();
    }

    private static final VideoControlsProvider parse$lambda$1() {
        return new VideoControlsProvider();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributeParser$Companion;", "", "<init>", "()V", "LOG_TAG", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

