/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.media3.common.Timeline;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.listener.OnTimelineChangedListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsButtonListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsVisibilityListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControls;
import com.devbrackets.android.exomedia.util.LongExtensionsKt;
import com.devbrackets.android.exomedia.util.Repeater;
import com.devbrackets.android.exomedia.util.ResourceExtensionsKt;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\r\n\u0002\b)\b&\u0018\u0000 \u00e2\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\n\u00e2\u0001\u00e3\u0001\u00e4\u0001\u00e5\u0001\u00e6\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u0014\u0010\u009e\u0001\u001a\u00030\u009f\u00012\b\u0010\u00a0\u0001\u001a\u00030\u0087\u0001H$J\n\u0010\u00a1\u0001\u001a\u00030\u009f\u0001H\u0014J\n\u0010\u00a2\u0001\u001a\u00030\u009f\u0001H\u0014J\u0012\u0010\u00a3\u0001\u001a\u00030\u009f\u00012\u0006\u0010R\u001a\u00020SH\u0016J\u0012\u0010\u00a4\u0001\u001a\u00030\u009f\u00012\u0006\u0010R\u001a\u00020SH\u0016J\u0013\u0010\u00a5\u0001\u001a\u00030\u009f\u00012\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010_J\u0014\u0010\u00a7\u0001\u001a\u00030\u009f\u00012\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u0001H\u0016J\u0014\u0010\u00aa\u0001\u001a\u00030\u009f\u00012\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001H\u0016J\u0014\u0010\u00ad\u0001\u001a\u00030\u009f\u00012\b\u0010\u00ae\u0001\u001a\u00030\u0081\u0001H\u0004J\u0012\u0010\u00af\u0001\u001a\u00030\u009f\u00012\b\u0010\u00b0\u0001\u001a\u00030\u0087\u0001J\u0014\u0010\u00b1\u0001\u001a\u00030\u009f\u00012\b\u0010\u00b2\u0001\u001a\u00030\u00a9\u0001H\u0014J\n\u0010\u00b3\u0001\u001a\u00030\u009f\u0001H\u0014J\u0013\u0010\u00b4\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00a8\u0001\u001a\u00020{H\u0016J\u0015\u0010\u00b5\u0001\u001a\u00030\u009f\u00012\t\u0010\u00a8\u0001\u001a\u0004\u0018\u00010{H\u0016J\u0015\u0010\u00b6\u0001\u001a\u00030\u009f\u00012\t\b\u0001\u0010\u00b7\u0001\u001a\u00020uH\u0016J\u0015\u0010\u00b8\u0001\u001a\u00030\u009f\u00012\t\b\u0001\u0010\u00b9\u0001\u001a\u00020uH\u0016J\u0013\u0010\u00ba\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00b7\u0001\u001a\u00020uH\u0004J\u001d\u0010\u00ba\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00b7\u0001\u001a\u00020u2\b\u0010\u00ae\u0001\u001a\u00030\u0081\u0001H\u0004J\u0013\u0010\u00bb\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00b9\u0001\u001a\u00020uH\u0004J\u001d\u0010\u00bb\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00b9\u0001\u001a\u00020u2\b\u0010\u00ae\u0001\u001a\u00030\u0081\u0001H\u0004J\u0014\u0010\u00bc\u0001\u001a\u00030\u009f\u00012\n\u0010\u00bd\u0001\u001a\u0005\u0018\u00010\u00be\u0001J\u0014\u0010\u00bf\u0001\u001a\u00030\u009f\u00012\n\u0010\u00c0\u0001\u001a\u0005\u0018\u00010\u00be\u0001J\u0012\u0010\u00c1\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c2\u0001\u001a\u00030\u0087\u0001J\u0012\u0010\u00c3\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c2\u0001\u001a\u00030\u0087\u0001J\u0014\u0010\u00c4\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c2\u0001\u001a\u00030\u0087\u0001H\u0016J\u0014\u0010\u00c5\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c2\u0001\u001a\u00030\u0087\u0001H\u0016J\u0012\u0010\u00c6\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c7\u0001\u001a\u00030\u0087\u0001J\u0012\u0010\u00c8\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c7\u0001\u001a\u00030\u0087\u0001J\u0014\u0010\u00c9\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c7\u0001\u001a\u00030\u0087\u0001H\u0016J\u0014\u0010\u00ca\u0001\u001a\u00030\u009f\u00012\b\u0010\u00c7\u0001\u001a\u00030\u0087\u0001H\u0016J\u0013\u0010\u00cb\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00cc\u0001\u001a\u00020\u001aH\u0016J\u0013\u0010\u00cd\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00cc\u0001\u001a\u00020\u001aH\u0016J\n\u0010\u00ce\u0001\u001a\u00030\u009f\u0001H\u0016J\u0014\u0010\u00cf\u0001\u001a\u00030\u009f\u00012\b\u0010\u00d0\u0001\u001a\u00030\u0087\u0001H\u0004J\b\u0010\u00cf\u0001\u001a\u00030\u009f\u0001J\u0011\u0010\u00d1\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00d2\u0001\u001a\u00020uJ\b\u0010\u00d3\u0001\u001a\u00030\u009f\u0001J\u0013\u0010\u00d3\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00d4\u0001\u001a\u00020uH\u0016J\n\u0010\u00d5\u0001\u001a\u00030\u009f\u0001H\u0014J\n\u0010\u00d6\u0001\u001a\u00030\u009f\u0001H\u0014J\u0015\u0010\u00d6\u0001\u001a\u00030\u009f\u00012\t\b\u0001\u0010\u00d7\u0001\u001a\u00020\fH\u0014J\n\u0010\u00d8\u0001\u001a\u00030\u009f\u0001H\u0004J\n\u0010\u00d9\u0001\u001a\u00030\u009f\u0001H\u0004J\n\u0010\u00da\u0001\u001a\u00030\u009f\u0001H\u0004J\n\u0010\u00db\u0001\u001a\u00030\u009f\u0001H\u0004J\n\u0010\u00dc\u0001\u001a\u00030\u009f\u0001H\u0004J\u0012\u0010\u00dd\u0001\u001a\u00030\u009f\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\n\u0010\u00de\u0001\u001a\u00030\u009f\u0001H\u0014J\n\u0010\u00df\u0001\u001a\u00030\u009f\u0001H\u0004J\n\u0010\u00e0\u0001\u001a\u00030\u009f\u0001H\u0004J+\u0010\u00e0\u0001\u001a\u00030\u009f\u00012\t\b\u0001\u0010\u00b7\u0001\u001a\u00020u2\t\b\u0001\u0010\u00b9\u0001\u001a\u00020u2\t\b\u0001\u0010\u00e1\u0001\u001a\u00020\fH\u0014R\u001a\u0010\u0010\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020&X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020&X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001a\u0010.\u001a\u00020&X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010(\"\u0004\b0\u0010*R\u001a\u00101\u001a\u000202X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020>X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010@\"\u0004\bE\u0010BR\u001a\u0010F\u001a\u00020GX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020MX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001c\u0010R\u001a\u0004\u0018\u00010SX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u001c\u0010X\u001a\u0004\u0018\u00010YX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001c\u0010^\u001a\u0004\u0018\u00010_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001c\u0010d\u001a\u0004\u0018\u00010eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u001e\u0010j\u001a\u00060kR\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0014\u0010p\u001a\u00020qX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010sR\u001a\u0010t\u001a\u00020uX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR\u001c\u0010z\u001a\u0004\u0018\u00010{X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010}\"\u0004\b~\u0010\u007fR \u0010\u0080\u0001\u001a\u00030\u0081\u0001X\u0084\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R \u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0084\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0086\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R \u0010\u008b\u0001\u001a\u00030\u0087\u0001X\u0084\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008c\u0001\u0010\u0088\u0001\"\u0006\b\u008d\u0001\u0010\u008a\u0001R\u001d\u0010\u008e\u0001\u001a\u00020uX\u0084\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008f\u0001\u0010w\"\u0005\b\u0090\u0001\u0010yR$\u0010\u0091\u0001\u001a\u0004\u0018\u00010uX\u0084\u000e\u00a2\u0006\u0015\n\u0003\u0010\u0096\u0001\u001a\u0006\b\u0092\u0001\u0010\u0093\u0001\"\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0017\u0010\u0097\u0001\u001a\u00020\f8eX\u00a4\u0004\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u0099\u0001R\u001e\u0010\u009a\u0001\u001a\t\u0012\u0004\u0012\u00020\u001a0\u009b\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u009c\u0001\u0010\u009d\u0001\u00a8\u0006\u00e7\u0001"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "Landroid/widget/RelativeLayout;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "Lcom/devbrackets/android/exomedia/listener/OnTimelineChangedListener;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "currentTimeTextView", "Landroid/widget/TextView;", "getCurrentTimeTextView", "()Landroid/widget/TextView;", "setCurrentTimeTextView", "(Landroid/widget/TextView;)V", "endTimeTextView", "getEndTimeTextView", "setEndTimeTextView", "timeSeparatorView", "Landroid/view/View;", "getTimeSeparatorView", "()Landroid/view/View;", "setTimeSeparatorView", "(Landroid/view/View;)V", "titleTextView", "getTitleTextView", "setTitleTextView", "subTitleTextView", "getSubTitleTextView", "setSubTitleTextView", "playPauseButton", "Landroid/widget/ImageButton;", "getPlayPauseButton", "()Landroid/widget/ImageButton;", "setPlayPauseButton", "(Landroid/widget/ImageButton;)V", "previousButton", "getPreviousButton", "setPreviousButton", "nextButton", "getNextButton", "setNextButton", "loadingProgressBar", "Landroid/widget/ProgressBar;", "getLoadingProgressBar", "()Landroid/widget/ProgressBar;", "setLoadingProgressBar", "(Landroid/widget/ProgressBar;)V", "seekBar", "Landroid/widget/SeekBar;", "getSeekBar", "()Landroid/widget/SeekBar;", "setSeekBar", "(Landroid/widget/SeekBar;)V", "playDrawable", "Landroid/graphics/drawable/Drawable;", "getPlayDrawable", "()Landroid/graphics/drawable/Drawable;", "setPlayDrawable", "(Landroid/graphics/drawable/Drawable;)V", "pauseDrawable", "getPauseDrawable", "setPauseDrawable", "visibilityHandler", "Landroid/os/Handler;", "getVisibilityHandler", "()Landroid/os/Handler;", "setVisibilityHandler", "(Landroid/os/Handler;)V", "progressPollRepeater", "Lcom/devbrackets/android/exomedia/util/Repeater;", "getProgressPollRepeater", "()Lcom/devbrackets/android/exomedia/util/Repeater;", "setProgressPollRepeater", "(Lcom/devbrackets/android/exomedia/util/Repeater;)V", "videoView", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "getVideoView", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "setVideoView", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "seekListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "getSeekListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "setSeekListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;)V", "buttonsListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "getButtonsListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "setButtonsListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;)V", "visibilityListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;", "getVisibilityListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;", "setVisibilityListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;)V", "internalListener", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "getInternalListener", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "setInternalListener", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;)V", "configuration", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Configuration;", "getConfiguration", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Configuration;", "hideDelay", "", "getHideDelay", "()J", "setHideDelay", "(J)V", "currentLoadState", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "getCurrentLoadState", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "setCurrentLoadState", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;)V", "currentTimelineStyle", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;", "getCurrentTimelineStyle", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;", "setCurrentTimelineStyle", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;)V", "isVisible", "", "()Z", "setVisible", "(Z)V", "userInteracting", "getUserInteracting", "setUserInteracting", "lastUpdatedPosition", "getLastUpdatedPosition", "setLastUpdatedPosition", "knownDuration", "getKnownDuration", "()Ljava/lang/Long;", "setKnownDuration", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "layoutResource", "getLayoutResource", "()I", "extraViews", "", "getExtraViews", "()Ljava/util/List;", "animateVisibility", "", "toVisible", "onAttachedToWindow", "onDetachedFromWindow", "onAttachedToView", "onDetachedFromView", "setButtonListener", "callback", "onPlaybackStateChange", "state", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "onTimelineChanged", "timeline", "Landroidx/media3/common/Timeline;", "onTimelineStyleUpdated", "style", "updatePlaybackState", "isPlaying", "reportLoadStarted", "playbackState", "reportLoadEnded", "onLoadStarted", "onLoadEnded", "setPosition", "position", "setDuration", "duration", "updatePositionText", "updateDurationText", "setTitle", "title", "", "setSubTitle", "subTitle", "setPreviousButtonEnabled", "enabled", "setNextButtonEnabled", "setRewindButtonEnabled", "setFastForwardButtonEnabled", "setPreviousButtonRemoved", "removed", "setNextButtonRemoved", "setRewindButtonRemoved", "setFastForwardButtonRemoved", "addExtraView", "view", "removeExtraView", "show", "hide", "delayed", "setDefaultHideDelay", "delayMs", "hideDelayed", "delay", "registerListeners", "updateButtonDrawables", "tintList", "onPlayPauseClick", "onPlayClick", "onPauseClick", "onPreviousClick", "onNextClick", "setup", "retrieveViews", "onVisibilityChanged", "updateProgress", "bufferPercent", "Companion", "Configuration", "LoadState", "TimelineStyle", "InternalListener", "library_release"})
public abstract class DefaultVideoControls
extends RelativeLayout
implements VideoControls,
OnTimelineChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected TextView currentTimeTextView;
    protected TextView endTimeTextView;
    protected View timeSeparatorView;
    protected TextView titleTextView;
    protected TextView subTitleTextView;
    protected ImageButton playPauseButton;
    protected ImageButton previousButton;
    protected ImageButton nextButton;
    protected ProgressBar loadingProgressBar;
    protected SeekBar seekBar;
    protected Drawable playDrawable;
    protected Drawable pauseDrawable;
    @NotNull
    private Handler visibilityHandler;
    @NotNull
    private Repeater progressPollRepeater;
    @Nullable
    private VideoView videoView;
    @Nullable
    private VideoControlsSeekListener seekListener;
    @Nullable
    private VideoControlsButtonListener buttonsListener;
    @Nullable
    private VideoControlsVisibilityListener visibilityListener;
    @NotNull
    private InternalListener internalListener;
    @NotNull
    private final Configuration configuration;
    private long hideDelay;
    @Nullable
    private LoadState currentLoadState;
    @NotNull
    private TimelineStyle currentTimelineStyle;
    private boolean isVisible;
    private boolean userInteracting;
    private long lastUpdatedPosition;
    @Nullable
    private Long knownDuration;
    private static final long DEFAULT_CONTROL_HIDE_DELAY = 2500L;

    @NotNull
    protected final TextView getCurrentTimeTextView() {
        TextView textView = this.currentTimeTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentTimeTextView");
        return null;
    }

    protected final void setCurrentTimeTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.currentTimeTextView = textView;
    }

    @NotNull
    protected final TextView getEndTimeTextView() {
        TextView textView = this.endTimeTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"endTimeTextView");
        return null;
    }

    protected final void setEndTimeTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.endTimeTextView = textView;
    }

    @NotNull
    protected final View getTimeSeparatorView() {
        View view = this.timeSeparatorView;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"timeSeparatorView");
        return null;
    }

    protected final void setTimeSeparatorView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.timeSeparatorView = view;
    }

    @NotNull
    protected final TextView getTitleTextView() {
        TextView textView = this.titleTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"titleTextView");
        return null;
    }

    protected final void setTitleTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.titleTextView = textView;
    }

    @NotNull
    protected final TextView getSubTitleTextView() {
        TextView textView = this.subTitleTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"subTitleTextView");
        return null;
    }

    protected final void setSubTitleTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.subTitleTextView = textView;
    }

    @NotNull
    protected final ImageButton getPlayPauseButton() {
        ImageButton imageButton = this.playPauseButton;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"playPauseButton");
        return null;
    }

    protected final void setPlayPauseButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.playPauseButton = imageButton;
    }

    @NotNull
    protected final ImageButton getPreviousButton() {
        ImageButton imageButton = this.previousButton;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        return null;
    }

    protected final void setPreviousButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.previousButton = imageButton;
    }

    @NotNull
    protected final ImageButton getNextButton() {
        ImageButton imageButton = this.nextButton;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        return null;
    }

    protected final void setNextButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.nextButton = imageButton;
    }

    @NotNull
    protected final ProgressBar getLoadingProgressBar() {
        ProgressBar progressBar = this.loadingProgressBar;
        if (progressBar != null) {
            return progressBar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"loadingProgressBar");
        return null;
    }

    protected final void setLoadingProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"<set-?>");
        this.loadingProgressBar = progressBar;
    }

    @NotNull
    protected final SeekBar getSeekBar() {
        SeekBar seekBar = this.seekBar;
        if (seekBar != null) {
            return seekBar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
        return null;
    }

    protected final void setSeekBar(@NotNull SeekBar seekBar) {
        Intrinsics.checkNotNullParameter((Object)seekBar, (String)"<set-?>");
        this.seekBar = seekBar;
    }

    @NotNull
    protected final Drawable getPlayDrawable() {
        Drawable drawable2 = this.playDrawable;
        if (drawable2 != null) {
            return drawable2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"playDrawable");
        return null;
    }

    protected final void setPlayDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.playDrawable = drawable2;
    }

    @NotNull
    protected final Drawable getPauseDrawable() {
        Drawable drawable2 = this.pauseDrawable;
        if (drawable2 != null) {
            return drawable2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pauseDrawable");
        return null;
    }

    protected final void setPauseDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.pauseDrawable = drawable2;
    }

    @NotNull
    protected final Handler getVisibilityHandler() {
        return this.visibilityHandler;
    }

    protected final void setVisibilityHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.visibilityHandler = handler;
    }

    @NotNull
    protected final Repeater getProgressPollRepeater() {
        return this.progressPollRepeater;
    }

    protected final void setProgressPollRepeater(@NotNull Repeater repeater) {
        Intrinsics.checkNotNullParameter((Object)repeater, (String)"<set-?>");
        this.progressPollRepeater = repeater;
    }

    @Nullable
    protected final VideoView getVideoView() {
        return this.videoView;
    }

    protected final void setVideoView(@Nullable VideoView videoView) {
        this.videoView = videoView;
    }

    @Nullable
    public final VideoControlsSeekListener getSeekListener() {
        return this.seekListener;
    }

    public final void setSeekListener(@Nullable VideoControlsSeekListener videoControlsSeekListener) {
        this.seekListener = videoControlsSeekListener;
    }

    @Nullable
    public final VideoControlsButtonListener getButtonsListener() {
        return this.buttonsListener;
    }

    public final void setButtonsListener(@Nullable VideoControlsButtonListener videoControlsButtonListener) {
        this.buttonsListener = videoControlsButtonListener;
    }

    @Nullable
    public final VideoControlsVisibilityListener getVisibilityListener() {
        return this.visibilityListener;
    }

    public final void setVisibilityListener(@Nullable VideoControlsVisibilityListener videoControlsVisibilityListener) {
        this.visibilityListener = videoControlsVisibilityListener;
    }

    @NotNull
    protected final InternalListener getInternalListener() {
        return this.internalListener;
    }

    protected final void setInternalListener(@NotNull InternalListener internalListener) {
        Intrinsics.checkNotNullParameter((Object)internalListener, (String)"<set-?>");
        this.internalListener = internalListener;
    }

    @NotNull
    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    protected final long getHideDelay() {
        return this.hideDelay;
    }

    protected final void setHideDelay(long l) {
        this.hideDelay = l;
    }

    @Nullable
    protected final LoadState getCurrentLoadState() {
        return this.currentLoadState;
    }

    protected final void setCurrentLoadState(@Nullable LoadState loadState) {
        this.currentLoadState = loadState;
    }

    @NotNull
    protected final TimelineStyle getCurrentTimelineStyle() {
        return this.currentTimelineStyle;
    }

    protected final void setCurrentTimelineStyle(@NotNull TimelineStyle timelineStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)timelineStyle), (String)"<set-?>");
        this.currentTimelineStyle = timelineStyle;
    }

    protected final boolean isVisible() {
        return this.isVisible;
    }

    protected final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    protected final boolean getUserInteracting() {
        return this.userInteracting;
    }

    protected final void setUserInteracting(boolean bl) {
        this.userInteracting = bl;
    }

    protected final long getLastUpdatedPosition() {
        return this.lastUpdatedPosition;
    }

    protected final void setLastUpdatedPosition(long l) {
        this.lastUpdatedPosition = l;
    }

    @Nullable
    protected final Long getKnownDuration() {
        return this.knownDuration;
    }

    protected final void setKnownDuration(@Nullable Long l) {
        this.knownDuration = l;
    }

    @LayoutRes
    protected abstract int getLayoutResource();

    @NotNull
    public List<View> getExtraViews() {
        return new LinkedList();
    }

    protected abstract void animateVisibility(boolean var1);

    public DefaultVideoControls(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, () -> DefaultVideoControls.progressPollRepeater$lambda$0(this), 3, null);
        this.internalListener = new InternalListener();
        this.configuration = new Configuration();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, () -> DefaultVideoControls.progressPollRepeater$lambda$0(this), 3, null);
        this.internalListener = new InternalListener();
        this.configuration = new Configuration();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, () -> DefaultVideoControls.progressPollRepeater$lambda$0(this), 3, null);
        this.internalListener = new InternalListener();
        this.configuration = new Configuration();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, () -> DefaultVideoControls.progressPollRepeater$lambda$0(this), 3, null);
        this.internalListener = new InternalListener();
        this.configuration = new Configuration();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.setup(context2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        VideoView videoView = this.videoView;
        boolean bl = videoView != null ? videoView.isPlaying() : false;
        if (bl) {
            this.updatePlaybackState(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.progressPollRepeater.stop();
    }

    @Override
    public void onAttachedToView(@NotNull VideoView videoView) {
        Intrinsics.checkNotNullParameter((Object)videoView, (String)"videoView");
        videoView.addView((View)this);
        videoView.setOnTimelineChangedListener(this);
        this.videoView = videoView;
    }

    @Override
    public void onDetachedFromView(@NotNull VideoView videoView) {
        Intrinsics.checkNotNullParameter((Object)videoView, (String)"videoView");
        videoView.removeView((View)this);
        videoView.setOnTimelineChangedListener(null);
        this.videoView = null;
    }

    public final void setButtonListener(@Nullable VideoControlsButtonListener callback) {
        this.buttonsListener = callback;
    }

    @Override
    public void onPlaybackStateChange(@NotNull PlaybackState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.reportLoadStarted(state);
                break;
            }
            case 3: {
                this.reportLoadStarted(state);
                break;
            }
            case 4: {
                this.reportLoadStarted(state);
                break;
            }
            case 5: {
                this.updatePlaybackState(false);
                break;
            }
            case 6: {
                this.updatePlaybackState(true);
                break;
            }
            case 7: {
                this.updatePlaybackState(false);
                break;
            }
            case 8: {
                this.updatePlaybackState(false);
                break;
            }
            case 9: {
                this.updatePlaybackState(false);
                break;
            }
            case 10: {
                this.updatePlaybackState(false);
                break;
            }
            case 11: {
                this.updatePlaybackState(false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void onTimelineChanged(@NotNull Timeline timeline) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        if (timeline.isEmpty()) {
            this.onTimelineStyleUpdated(TimelineStyle.UNKNOWN);
            return;
        }
        Timeline.Window window = new Timeline.Window();
        timeline.getWindow(timeline.getWindowCount() - 1, window);
        if (window.isPlaceholder) {
            this.onTimelineStyleUpdated(TimelineStyle.UNKNOWN);
            return;
        }
        if (!window.isLive()) {
            this.onTimelineStyleUpdated(TimelineStyle.ON_DEMAND);
            return;
        }
        timeline.getWindow(0, window);
        if (window.isPlaceholder) {
            this.onTimelineStyleUpdated(TimelineStyle.UNKNOWN);
            return;
        }
        boolean rollingStart = window.isDynamic || window.isLive();
        TimelineStyle style = rollingStart ? TimelineStyle.LIVE : TimelineStyle.EVENT;
        this.onTimelineStyleUpdated(style);
    }

    protected final void onTimelineStyleUpdated(@NotNull TimelineStyle style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        if (style == this.currentTimelineStyle) {
            return;
        }
        VideoView videoView = this.videoView;
        if (videoView != null) {
            VideoView it = videoView;
            boolean bl = false;
            this.updatePositionText(it.getCurrentPosition(), style);
            this.updateDurationText(it.getDuration(), style);
        }
        this.currentTimelineStyle = style;
    }

    public final void updatePlaybackState(boolean isPlaying) {
        this.getPlayPauseButton().setImageDrawable(isPlaying ? this.getPauseDrawable() : this.getPlayDrawable());
        this.progressPollRepeater.start();
        this.reportLoadEnded();
        if (isPlaying) {
            this.hideDelayed();
        } else {
            this.show();
        }
    }

    protected void reportLoadStarted(@NotNull PlaybackState playbackState) {
        block6: {
            int currentPriority;
            LoadState newState;
            LoadState loadState;
            Intrinsics.checkNotNullParameter((Object)((Object)playbackState), (String)"playbackState");
            switch (WhenMappings.$EnumSwitchMapping$0[playbackState.ordinal()]) {
                case 2: {
                    loadState = LoadState.PREPARING;
                    break;
                }
                case 3: {
                    loadState = LoadState.BUFFERING;
                    break;
                }
                case 4: {
                    loadState = LoadState.SEEKING;
                    break;
                }
                default: {
                    loadState = null;
                }
            }
            LoadState loadState2 = newState = loadState;
            int newPriority = loadState2 != null ? loadState2.ordinal() : 99;
            LoadState loadState3 = this.currentLoadState;
            int n = currentPriority = loadState3 != null ? loadState3.ordinal() : 100;
            if (newPriority >= currentPriority) {
                return;
            }
            LoadState loadState4 = newState;
            if (loadState4 == null) break block6;
            LoadState it = loadState4;
            boolean bl = false;
            this.currentLoadState = it;
            this.onLoadStarted(it);
        }
    }

    protected void reportLoadEnded() {
        LoadState loadState = this.currentLoadState;
        if (loadState != null) {
            LoadState it = loadState;
            boolean bl = false;
            this.onLoadEnded(it);
        }
        this.currentLoadState = null;
    }

    public void onLoadStarted(@NotNull LoadState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
    }

    public void onLoadEnded(@Nullable LoadState state) {
    }

    public void setPosition(@IntRange(from=0L) long position) {
        this.getSeekBar().setProgress((int)position);
        this.updatePositionText(position);
    }

    public void setDuration(@IntRange(from=0L) long duration) {
        if (duration != (long)this.getSeekBar().getMax()) {
            this.getSeekBar().setMax((int)duration);
            this.updateDurationText(duration);
        }
    }

    protected final void updatePositionText(long position) {
        this.updatePositionText(position, this.currentTimelineStyle);
    }

    protected final void updatePositionText(long position, @NotNull TimelineStyle style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        if (style == this.currentTimelineStyle && Math.abs(position - this.lastUpdatedPosition) < 1000L && this.lastUpdatedPosition != 0L) {
            return;
        }
        this.lastUpdatedPosition = position;
        switch (WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedDuration(position));
                break;
            }
            case 4: {
                this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedDuration(position));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    protected final void updateDurationText(long duration) {
        this.updateDurationText(duration, this.currentTimelineStyle);
    }

    protected final void updateDurationText(long duration, @NotNull TimelineStyle style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        if (style == this.currentTimelineStyle) {
            Long l = this.knownDuration;
            long l2 = duration;
            if (l != null && l == l2) {
                return;
            }
        }
        this.knownDuration = duration;
        switch (WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.getEndTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedDuration(duration));
                break;
            }
            case 4: {
                this.getEndTimeTextView().setText((CharSequence)this.getContext().getString(R.string.exomedia_controls_live));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void setTitle(@Nullable CharSequence title) {
        this.getTitleTextView().setText(title);
    }

    public final void setSubTitle(@Nullable CharSequence subTitle) {
        this.getSubTitleTextView().setText(subTitle);
    }

    public final void setPreviousButtonEnabled(boolean enabled) {
        this.getPreviousButton().setEnabled(enabled);
        this.configuration.setEnabled(R.id.exomedia_controls_previous_btn, enabled);
    }

    public final void setNextButtonEnabled(boolean enabled) {
        this.getNextButton().setEnabled(enabled);
        this.configuration.setEnabled(R.id.exomedia_controls_next_btn, enabled);
    }

    public void setRewindButtonEnabled(boolean enabled) {
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
    }

    public final void setPreviousButtonRemoved(boolean removed) {
        this.getPreviousButton().setVisibility(removed ? 8 : 0);
        this.configuration.setRemoved(R.id.exomedia_controls_previous_btn, removed);
    }

    public final void setNextButtonRemoved(boolean removed) {
        this.getNextButton().setVisibility(removed ? 8 : 0);
        this.configuration.setRemoved(R.id.exomedia_controls_next_btn, removed);
    }

    public void setRewindButtonRemoved(boolean removed) {
    }

    public void setFastForwardButtonRemoved(boolean removed) {
    }

    public void addExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    public void removeExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    public void show() {
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(true);
    }

    protected final void hide(boolean delayed) {
        if (delayed) {
            this.hideDelayed();
        } else {
            this.hide();
        }
    }

    public final void hide() {
        if (this.currentLoadState != null) {
            return;
        }
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(false);
    }

    public final void setDefaultHideDelay(long delayMs) {
        if (delayMs < 0L) {
            return;
        }
        this.hideDelay = delayMs;
    }

    public final void hideDelayed() {
        this.hideDelayed(this.hideDelay);
    }

    public void hideDelayed(long delay) {
        if (delay < 0L || this.currentLoadState != null) {
            return;
        }
        this.visibilityHandler.postDelayed(() -> DefaultVideoControls.hideDelayed$lambda$4(this), delay);
    }

    protected void registerListeners() {
        this.getPlayPauseButton().setOnClickListener(arg_0 -> DefaultVideoControls.registerListeners$lambda$5(this, arg_0));
        this.getPreviousButton().setOnClickListener(arg_0 -> DefaultVideoControls.registerListeners$lambda$6(this, arg_0));
        this.getNextButton().setOnClickListener(arg_0 -> DefaultVideoControls.registerListeners$lambda$7(this, arg_0));
    }

    protected void updateButtonDrawables() {
        this.updateButtonDrawables(R.color.exomedia_controls_button_foreground);
    }

    protected void updateButtonDrawables(@ColorRes int tintList) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.setPlayDrawable(ResourceExtensionsKt.tintListCompat(context, R.drawable.exomedia_ic_play_arrow_white, tintList));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.setPauseDrawable(ResourceExtensionsKt.tintListCompat(context2, R.drawable.exomedia_ic_pause_white, tintList));
        this.getPlayPauseButton().setImageDrawable(this.getPlayDrawable());
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
        Drawable previousDrawable = ResourceExtensionsKt.tintListCompat(context3, R.drawable.exomedia_ic_skip_previous_white, tintList);
        this.getPreviousButton().setImageDrawable(previousDrawable);
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
        Drawable nextDrawable = ResourceExtensionsKt.tintListCompat(context4, R.drawable.exomedia_ic_skip_next_white, tintList);
        this.getNextButton().setImageDrawable(nextDrawable);
    }

    protected final void onPlayPauseClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPlayPauseClicked() : false)) {
            this.internalListener.onPlayPauseClicked();
        }
    }

    protected final void onPlayClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPlayClicked() : false)) {
            this.internalListener.onPlayClicked();
        }
    }

    protected final void onPauseClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPauseClicked() : false)) {
            this.internalListener.onPauseClicked();
        }
    }

    protected final void onPreviousClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPreviousClicked() : false)) {
            this.internalListener.onPreviousClicked();
        }
    }

    protected final void onNextClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onNextClicked() : false)) {
            this.internalListener.onNextClicked();
        }
    }

    protected void setup(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)this.getLayoutResource(), (ViewGroup)((ViewGroup)this));
        this.retrieveViews();
        this.registerListeners();
        this.updateButtonDrawables();
    }

    protected void retrieveViews() {
        this.setCurrentTimeTextView((TextView)this.findViewById(R.id.exomedia_controls_current_time));
        this.setEndTimeTextView((TextView)this.findViewById(R.id.exomedia_controls_end_time));
        this.setTimeSeparatorView(this.findViewById(R.id.exomedia_controls_time_separator));
        this.setTitleTextView((TextView)this.findViewById(R.id.exomedia_controls_title));
        this.setSubTitleTextView((TextView)this.findViewById(R.id.exomedia_controls_sub_title));
        this.setPlayPauseButton((ImageButton)this.findViewById(R.id.exomedia_controls_play_pause_btn));
        this.setPreviousButton((ImageButton)this.findViewById(R.id.exomedia_controls_previous_btn));
        this.setNextButton((ImageButton)this.findViewById(R.id.exomedia_controls_next_btn));
        this.setLoadingProgressBar((ProgressBar)this.findViewById(R.id.exomedia_controls_video_loading));
        this.setSeekBar((SeekBar)this.findViewById(R.id.exomedia_controls_video_seek));
    }

    protected final void onVisibilityChanged() {
        block1: {
            block0: {
                if (!this.isVisible) break block0;
                VideoControlsVisibilityListener videoControlsVisibilityListener = this.visibilityListener;
                if (videoControlsVisibilityListener == null) break block1;
                videoControlsVisibilityListener.onControlsShown();
                break block1;
            }
            VideoControlsVisibilityListener videoControlsVisibilityListener = this.visibilityListener;
            if (videoControlsVisibilityListener == null) break block1;
            videoControlsVisibilityListener.onControlsHidden();
        }
    }

    protected final void updateProgress() {
        block2: {
            VideoView it;
            block4: {
                block3: {
                    VideoView videoView = this.videoView;
                    if (videoView == null) break block2;
                    it = videoView;
                    boolean bl = false;
                    if (this.knownDuration == null) break block3;
                    Long l = this.knownDuration;
                    if (l != null && it.getDuration() == l.longValue()) break block4;
                }
                this.setDuration(it.getDuration());
            }
            this.updateProgress(it.getCurrentPosition(), it.getDuration(), it.getBufferPercentage());
        }
    }

    protected void updateProgress(@IntRange(from=0L) long position, @IntRange(from=0L) long duration, @IntRange(from=0L, to=100L) int bufferPercent) {
        if (!this.userInteracting) {
            this.getSeekBar().setSecondaryProgress((int)((float)this.getSeekBar().getMax() * ((float)bufferPercent / (float)100)));
            this.getSeekBar().setProgress((int)position);
            this.updatePositionText(position);
        }
    }

    private static final Unit progressPollRepeater$lambda$0(DefaultVideoControls this$0) {
        this$0.updateProgress();
        return Unit.INSTANCE;
    }

    private static final void hideDelayed$lambda$4(DefaultVideoControls this$0) {
        this$0.hide();
    }

    private static final void registerListeners$lambda$5(DefaultVideoControls this$0, View it) {
        this$0.onPlayPauseClick();
    }

    private static final void registerListeners$lambda$6(DefaultVideoControls this$0, View it) {
        this$0.onPreviousClick();
    }

    private static final void registerListeners$lambda$7(DefaultVideoControls this$0, View it) {
        this$0.onNextClick();
    }

    public static final long getDEFAULT_CONTROL_HIDE_DELAY() {
        return Companion.getDEFAULT_CONTROL_HIDE_DELAY();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Companion;", "", "<init>", "()V", "DEFAULT_CONTROL_HIDE_DELAY", "", "getDEFAULT_CONTROL_HIDE_DELAY$annotations", "getDEFAULT_CONTROL_HIDE_DELAY", "()J", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_CONTROL_HIDE_DELAY() {
            return DEFAULT_CONTROL_HIDE_DELAY;
        }

        @JvmStatic
        public static /* synthetic */ void getDEFAULT_CONTROL_HIDE_DELAY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0006J\u0018\u0010\u000f\u001a\u00020\f2\b\b\u0001\u0010\n\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u0006J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\n\u001a\u00020\u0006H\u0002J(\u0010\u0013\u001a\u00020\f2\b\b\u0001\u0010\n\u001a\u00020\u00062\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0015H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Configuration;", "", "<init>", "()V", "itemConfigs", "", "", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Configuration$ItemConfig;", "isEnabled", "", "id", "setEnabled", "", "enabled", "isRemoved", "setRemoved", "removed", "visibility", "getViewConfiguration", "updateViewConfiguration", "action", "Lkotlin/Function1;", "ItemConfig", "library_release"})
    protected static final class Configuration {
        @NotNull
        private final Map<Integer, ItemConfig> itemConfigs = new LinkedHashMap();

        public final boolean isEnabled(@IdRes int id2) {
            ItemConfig itemConfig = this.getViewConfiguration(id2);
            return itemConfig != null ? itemConfig.getEnabled() : true;
        }

        public final void setEnabled(@IdRes int id2, boolean enabled) {
            this.updateViewConfiguration(id2, (Function1<? super ItemConfig, ItemConfig>)((Function1)arg_0 -> Configuration.setEnabled$lambda$0(enabled, arg_0)));
        }

        public final boolean isRemoved(@IdRes int id2) {
            ItemConfig itemConfig = this.getViewConfiguration(id2);
            return itemConfig != null ? itemConfig.getRemoved() : false;
        }

        public final void setRemoved(@IdRes int id2, boolean removed) {
            this.updateViewConfiguration(id2, (Function1<? super ItemConfig, ItemConfig>)((Function1)arg_0 -> Configuration.setRemoved$lambda$1(removed, arg_0)));
        }

        public final int visibility(@IdRes int id2) {
            return this.isRemoved(id2) ? 8 : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ItemConfig getViewConfiguration(@IdRes int id2) {
            ItemConfig itemConfig;
            Configuration configuration = this;
            synchronized (configuration) {
                boolean bl = false;
                itemConfig = this.itemConfigs.get(id2);
            }
            return itemConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void updateViewConfiguration(@IdRes int id2, Function1<? super ItemConfig, ItemConfig> action) {
            Configuration configuration = this;
            synchronized (configuration) {
                ItemConfig itemConfig;
                ItemConfig newConfig;
                boolean bl = false;
                ItemConfig itemConfig2 = this.itemConfigs.get(id2);
                if (itemConfig2 == null) {
                    itemConfig2 = new ItemConfig(false, false, 3, null);
                }
                if ((newConfig = (ItemConfig)action.invoke((Object)itemConfig2)) == null) {
                    itemConfig = this.itemConfigs.remove(id2);
                } else {
                    Integer n = id2;
                    this.itemConfigs.put(n, newConfig);
                    itemConfig = Unit.INSTANCE;
                }
                ItemConfig itemConfig3 = itemConfig;
            }
        }

        private static final ItemConfig setEnabled$lambda$0(boolean $enabled, ItemConfig it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ItemConfig.copy$default(it, $enabled, false, 2, null);
        }

        private static final ItemConfig setRemoved$lambda$1(boolean $removed, ItemConfig it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ItemConfig.copy$default(it, false, $removed, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Configuration$ItemConfig;", "", "enabled", "", "removed", "<init>", "(ZZ)V", "getEnabled", "()Z", "getRemoved", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "library_release"})
        private static final class ItemConfig {
            private final boolean enabled;
            private final boolean removed;

            public ItemConfig(boolean enabled, boolean removed) {
                this.enabled = enabled;
                this.removed = removed;
            }

            public /* synthetic */ ItemConfig(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    bl2 = false;
                }
                this(bl, bl2);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final boolean getRemoved() {
                return this.removed;
            }

            public final boolean component1() {
                return this.enabled;
            }

            public final boolean component2() {
                return this.removed;
            }

            @NotNull
            public final ItemConfig copy(boolean enabled, boolean removed) {
                return new ItemConfig(enabled, removed);
            }

            public static /* synthetic */ ItemConfig copy$default(ItemConfig itemConfig, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = itemConfig.enabled;
                }
                if ((n & 2) != 0) {
                    bl2 = itemConfig.removed;
                }
                return itemConfig.copy(bl, bl2);
            }

            @NotNull
            public String toString() {
                return "ItemConfig(enabled=" + this.enabled + ", removed=" + this.removed + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.enabled);
                result = result * 31 + Boolean.hashCode(this.removed);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ItemConfig)) {
                    return false;
                }
                ItemConfig itemConfig = (ItemConfig)other;
                if (this.enabled != itemConfig.enabled) {
                    return false;
                }
                return this.removed == itemConfig.removed;
            }

            public ItemConfig() {
                this(false, false, 3, null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\t\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;)V", "pausedForSeek", "", "onPlayPauseClicked", "onPlayClicked", "onPauseClicked", "onPreviousClicked", "onNextClicked", "onRewindClicked", "onFastForwardClicked", "onSeekStarted", "onSeekEnded", "seekTime", "", "library_release"})
    protected class InternalListener
    implements VideoControlsSeekListener,
    VideoControlsButtonListener {
        private boolean pausedForSeek;

        @Override
        public boolean onPlayPauseClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView it = videoView;
                boolean bl2 = false;
                if (it.isPlaying()) {
                    VideoView.pause$default(it, false, 1, null);
                } else {
                    it.start();
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPlayClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView it = videoView;
                boolean bl2 = false;
                if (!it.isPlaying()) {
                    it.start();
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPauseClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView it = videoView;
                boolean bl2 = false;
                if (it.isPlaying()) {
                    VideoView.pause$default(it, false, 1, null);
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPreviousClicked() {
            return false;
        }

        @Override
        public boolean onNextClicked() {
            return false;
        }

        @Override
        public boolean onRewindClicked() {
            return false;
        }

        @Override
        public boolean onFastForwardClicked() {
            return false;
        }

        @Override
        public boolean onSeekStarted() {
            if (DefaultVideoControls.this.getVideoView() == null) {
                return false;
            }
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            boolean bl = videoView != null ? videoView.isPlaying() : false;
            if (bl) {
                this.pausedForSeek = true;
                VideoView videoView2 = DefaultVideoControls.this.getVideoView();
                if (videoView2 != null) {
                    videoView2.pause(true);
                }
            }
            DefaultVideoControls.this.show();
            return true;
        }

        @Override
        public boolean onSeekEnded(long seekTime) {
            if (DefaultVideoControls.this.getVideoView() == null) {
                return false;
            }
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                videoView.seekTo(seekTime);
            }
            if (this.pausedForSeek) {
                this.pausedForSeek = false;
                VideoView videoView2 = DefaultVideoControls.this.getVideoView();
                if (videoView2 != null) {
                    videoView2.start();
                }
                DefaultVideoControls.this.hideDelayed();
            }
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "", "<init>", "(Ljava/lang/String;I)V", "PREPARING", "BUFFERING", "SEEKING", "library_release"})
    public static final class LoadState
    extends Enum<LoadState> {
        public static final /* enum */ LoadState PREPARING = new LoadState();
        public static final /* enum */ LoadState BUFFERING = new LoadState();
        public static final /* enum */ LoadState SEEKING = new LoadState();
        private static final /* synthetic */ LoadState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoadState[] values() {
            return (LoadState[])$VALUES.clone();
        }

        public static LoadState valueOf(String value) {
            return Enum.valueOf(LoadState.class, value);
        }

        @NotNull
        public static EnumEntries<LoadState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loadStateArray = new LoadState[]{LoadState.PREPARING, LoadState.BUFFERING, LoadState.SEEKING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;", "", "<init>", "(Ljava/lang/String;I)V", "UNKNOWN", "LIVE", "EVENT", "ON_DEMAND", "library_release"})
    protected static final class TimelineStyle
    extends Enum<TimelineStyle> {
        public static final /* enum */ TimelineStyle UNKNOWN = new TimelineStyle();
        public static final /* enum */ TimelineStyle LIVE = new TimelineStyle();
        public static final /* enum */ TimelineStyle EVENT = new TimelineStyle();
        public static final /* enum */ TimelineStyle ON_DEMAND = new TimelineStyle();
        private static final /* synthetic */ TimelineStyle[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TimelineStyle[] values() {
            return (TimelineStyle[])$VALUES.clone();
        }

        public static TimelineStyle valueOf(String value) {
            return Enum.valueOf(TimelineStyle.class, value);
        }

        @NotNull
        public static EnumEntries<TimelineStyle> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = timelineStyleArray = new TimelineStyle[]{TimelineStyle.UNKNOWN, TimelineStyle.LIVE, TimelineStyle.EVENT, TimelineStyle.ON_DEMAND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PlaybackState.values().length];
            try {
                nArray[PlaybackState.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.PREPARING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.BUFFERING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.SEEKING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.READY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.PLAYING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.PAUSED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.COMPLETED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.STOPPED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.RELEASED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.ERROR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimelineStyle.values().length];
            try {
                nArray[TimelineStyle.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimelineStyle.ON_DEMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimelineStyle.EVENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimelineStyle.LIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

