/*
 * Decompiled with CFR 0.152.
 */
package com.deviceinsight.helm;

import com.deviceinsight.helm.AbstractHelmMojo;
import com.deviceinsight.helm.util.PlatformDetector;
import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0004J\b\u0010%\u001a\u00020\u0004H\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00118\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/deviceinsight/helm/ResolveHelmMojo;", "Lcom/deviceinsight/helm/AbstractHelmMojo;", "()V", "helm", "", "getHelm", "()Ljava/lang/String;", "setHelm", "(Ljava/lang/String;)V", "helmArtifactId", "helmDownloadUrl", "Ljava/net/URI;", "helmGroupId", "helmVersion", "localRepository", "Lorg/apache/maven/artifact/repository/ArtifactRepository;", "remoteRepositories", "", "repositorySystem", "Lorg/apache/maven/repository/RepositorySystem;", "downloadAndInstallHelm", "", "artifact", "Lorg/apache/maven/artifact/Artifact;", "platformIdentifier", "downloadFileAndExtractBinary", "url", "Ljava/net/URL;", "destination", "Ljava/nio/file/Path;", "execute", "isHelmBinary", "", "entry", "Ljava/util/zip/ZipEntry;", "majorHelmVersion", "", "resolveHelmBinary", "helm-maven-plugin"})
@Mojo(name="resolve", defaultPhase=LifecyclePhase.NONE)
@SourceDebugExtension(value={"SMAP\nResolveHelmMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolveHelmMojo.kt\ncom/deviceinsight/helm/ResolveHelmMojo\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,145:1\n17#2,6:146\n*S KotlinDebug\n*F\n+ 1 ResolveHelmMojo.kt\ncom/deviceinsight/helm/ResolveHelmMojo\n*L\n112#1:146,6\n*E\n"})
public class ResolveHelmMojo
extends AbstractHelmMojo {
    @Parameter(property="helmGroupId", defaultValue="com.deviceinsight.helm")
    private String helmGroupId;
    @Parameter(property="helmArtifactId", defaultValue="helm")
    private String helmArtifactId;
    @Parameter(property="helmVersion", required=true)
    private String helmVersion;
    @Parameter(property="helmDownloadUrl", defaultValue="https://get.helm.sh/")
    private URI helmDownloadUrl;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<? extends ArtifactRepository> remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    protected String helm;

    @NotNull
    protected final String getHelm() {
        String string = this.helm;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"helm");
        return null;
    }

    protected final void setHelm(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.helm = string;
    }

    @NotNull
    protected final String resolveHelmBinary() {
        String string;
        String string2;
        String string3;
        String platformIdentifier = PlatformDetector.INSTANCE.detectHelmReleasePlatformIdentifier();
        RepositorySystem repositorySystem = this.repositorySystem;
        if (repositorySystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositorySystem");
            repositorySystem = null;
        }
        if ((string3 = this.helmGroupId) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helmGroupId");
            string3 = null;
        }
        if ((string2 = this.helmArtifactId) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helmArtifactId");
            string2 = null;
        }
        if ((string = this.helmVersion) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helmVersion");
            string = null;
        }
        Artifact artifact = repositorySystem.createArtifactWithClassifier(string3, string2, string, "binary", platformIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"repositorySystem.createA\u2026,\n\t\t\t\tplatformIdentifier)");
        Artifact helmArtifact = artifact;
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(helmArtifact);
        request.setResolveTransitively(false);
        ArtifactRepository artifactRepository = this.localRepository;
        if (artifactRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localRepository");
            artifactRepository = null;
        }
        request.setLocalRepository(artifactRepository);
        List<? extends ArtifactRepository> list = this.remoteRepositories;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteRepositories");
            list = null;
        }
        request.setRemoteRepositories(list);
        RepositorySystem repositorySystem2 = this.repositorySystem;
        if (repositorySystem2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositorySystem");
            repositorySystem2 = null;
        }
        ArtifactResolutionResult artifactResolutionResult = repositorySystem2.resolve(request);
        Intrinsics.checkNotNullExpressionValue((Object)artifactResolutionResult, (String)"repositorySystem.resolve(request)");
        ArtifactResolutionResult resolutionResult = artifactResolutionResult;
        if (!resolutionResult.isSuccess()) {
            this.getLog().info((CharSequence)"Artifact not found in remote repositories");
            this.downloadAndInstallHelm(helmArtifact, platformIdentifier);
        }
        helmArtifact.getFile().setExecutable(true);
        String string4 = helmArtifact.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"helmArtifact.file.absolutePath");
        return string4;
    }

    private final void downloadAndInstallHelm(Artifact artifact, String platformIdentifier) {
        StringBuilder stringBuilder = new StringBuilder().append("helm-v");
        String string = this.helmVersion;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helmVersion");
            string = null;
        }
        String fileName = stringBuilder.append(string).append('-').append(platformIdentifier).toString();
        Path targetFile = artifact.getFile().toPath();
        Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        URI uRI = this.helmDownloadUrl;
        if (uRI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helmDownloadUrl");
            uRI = null;
        }
        URL url = uRI.resolve("./" + fileName + ".zip").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
        Intrinsics.checkNotNullExpressionValue((Object)targetFile, (String)"targetFile");
        this.downloadFileAndExtractBinary(url, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadFileAndExtractBinary(URL url, Path destination) {
        URLConnection httpConnection = url.openConnection();
        httpConnection.connect();
        if (!(httpConnection instanceof HttpURLConnection) || ((HttpURLConnection)httpConnection).getResponseCode() != 200) {
            throw new RuntimeException("Could not download file from " + url);
        }
        double sizeInMiB = (double)((HttpURLConnection)httpConnection).getContentLengthLong() / 1024.0 / 1024.0;
        Log log = this.getLog();
        String string = "Downloading " + url + "; need to get %.1f MiB...";
        Object[] objectArray = new Object[]{sizeInMiB};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        log.info((CharSequence)string2);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Closeable closeable = ((HttpURLConnection)httpConnection).getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new ZipInputStream(it);
            Throwable throwable2 = null;
            try {
                ZipInputStream zip = (ZipInputStream)closeable2;
                boolean bl3 = false;
                ZipEntry entry = zip.getNextEntry();
                do {
                    if (entry == null) continue;
                    if (this.isHelmBinary(entry)) {
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(zip, destination, copyOptionArray);
                        zip.closeEntry();
                        break;
                    }
                    zip.closeEntry();
                    entry = zip.getNextEntry();
                } while (entry != null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long downloadTimeMillis = System.currentTimeMillis() - start$iv;
        Log log2 = this.getLog();
        String string3 = "Download took %.1f seconds";
        Object[] objectArray2 = new Object[]{(double)downloadTimeMillis / 1000.0};
        String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
        log2.info((CharSequence)string4);
    }

    protected final int majorHelmVersion() {
        String string = this.helmVersion;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helmVersion");
            string = null;
        }
        char[] cArray = new char[]{'.'};
        return Integer.parseInt((String)SequencesKt.first((Sequence)StringsKt.splitToSequence$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHelmBinary(ZipEntry entry) {
        if (entry.isDirectory()) return false;
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
        if (StringsKt.endsWith$default((String)string, (String)"helm", (boolean)false, (int)2, null)) return true;
        String string2 = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
        if (!StringsKt.endsWith$default((String)string2, (String)"helm.exe", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public void execute() {
        this.setHelm(this.resolveHelmBinary());
    }
}

