/*
 * Decompiled with CFR 0.152.
 */
package com.deviceinsight.helm;

import com.deviceinsight.helm.ChartDeploymentRequest;
import com.deviceinsight.helm.util.ServerAuthentication;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\b\u0007\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00158\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u001b8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-\u00b2\u0006\f\u0010.\u001a\u0004\u0018\u00010/X\u008a\u0084\u0002"}, d2={"Lcom/deviceinsight/helm/DeployMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "Lcom/deviceinsight/helm/util/ServerAuthentication;", "()V", "chartDeleteUrl", "", "chartName", "chartPublishMethod", "chartPublishUrl", "chartRepoPassword", "chartRepoServerId", "chartRepoUrl", "chartRepoUsername", "chartVersion", "deployAtEnd", "", "project", "Lorg/apache/maven/project/MavenProject;", "reactorProjects", "", "securityDispatcher", "Lorg/sonatype/plexus/components/sec/dispatcher/SecDispatcher;", "getSecurityDispatcher", "()Lorg/sonatype/plexus/components/sec/dispatcher/SecDispatcher;", "setSecurityDispatcher", "(Lorg/sonatype/plexus/components/sec/dispatcher/SecDispatcher;)V", "settings", "Lorg/apache/maven/settings/Settings;", "getSettings", "()Lorg/apache/maven/settings/Settings;", "setSettings", "(Lorg/apache/maven/settings/Settings;)V", "skip", "skipSnapshots", "chartFileExists", "chartDeploymentRequest", "Lcom/deviceinsight/helm/ChartDeploymentRequest;", "createChartRepoClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "execute", "", "publishChart", "publishToRepo", "removeChartIfExists", "Companion", "helm-maven-plugin", "server", "Lorg/apache/maven/settings/Server;"})
@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
@SourceDebugExtension(value={"SMAP\nDeployMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployMojo.kt\ncom/deviceinsight/helm/DeployMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1855#2,2:252\n*S KotlinDebug\n*F\n+ 1 DeployMojo.kt\ncom/deviceinsight/helm/DeployMojo\n*L\n141#1:252,2\n*E\n"})
public final class DeployMojo
extends AbstractMojo
implements ServerAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Component(role=SecDispatcher.class, hint="default")
    public SecDispatcher securityDispatcher;
    @Parameter(property="chartName", required=false)
    @Nullable
    private String chartName;
    @Parameter(property="chartVersion", required=false)
    @Nullable
    private String chartVersion;
    @Parameter(property="chartRepoUrl", required=false)
    @Nullable
    private String chartRepoUrl;
    @Parameter(property="chartPublishUrl", required=false)
    @Nullable
    private String chartPublishUrl;
    @Parameter(property="chartPublishMethod", defaultValue="POST", required=false)
    @NotNull
    private String chartPublishMethod = "POST";
    @Parameter(property="chartDeleteUrl", required=false)
    @Nullable
    private String chartDeleteUrl;
    @Parameter(property="chartRepoUsername", required=false)
    @Nullable
    private String chartRepoUsername;
    @Parameter(property="chartRepoPassword", required=false)
    @Nullable
    private String chartRepoPassword;
    @Parameter(property="chartRepoServerId", required=false)
    @Nullable
    private String chartRepoServerId;
    @Parameter(property="skipSnapshots", defaultValue="true", required=false)
    private boolean skipSnapshots = true;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<? extends MavenProject> reactorProjects;
    @Parameter(defaultValue="${settings}", readonly=true)
    public Settings settings;
    @Parameter(property="helm.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="helm.deployAtEnd", defaultValue="false")
    private boolean deployAtEnd;
    @NotNull
    private static final List<ChartDeploymentRequest> deployAtEndDeploymentRequests;
    @NotNull
    private static final AtomicInteger readyProjectsCounter;

    @Override
    @NotNull
    public SecDispatcher getSecurityDispatcher() {
        SecDispatcher secDispatcher = this.securityDispatcher;
        if (secDispatcher != null) {
            return secDispatcher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"securityDispatcher");
        return null;
    }

    public void setSecurityDispatcher(@NotNull SecDispatcher secDispatcher) {
        Intrinsics.checkNotNullParameter((Object)secDispatcher, (String)"<set-?>");
        this.securityDispatcher = secDispatcher;
    }

    @Override
    @NotNull
    public Settings getSettings() {
        Settings settings = this.settings;
        if (settings != null) {
            return settings;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        return null;
    }

    public void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block16: {
            if (this.skip) {
                this.getLog().info((CharSequence)"helm-deploy has been skipped");
                return;
            }
            try {
                boolean projectsReady;
                MavenProject mavenProject;
                String chartRepoPassword;
                String string;
                String chartRepoUsername;
                Lazy server$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Server>(this){
                    final /* synthetic */ DeployMojo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Server invoke() {
                        return this.this$0.getServer(DeployMojo.access$getChartRepoServerId$p(this.this$0));
                    }
                }));
                String string2 = this.chartRepoUsername;
                if (string2 == null) {
                    Server server2 = DeployMojo.execute$lambda$0((Lazy<? extends Server>)server$delegate);
                    string2 = chartRepoUsername = server2 != null ? server2.getUsername() : null;
                }
                if ((string = this.chartRepoPassword) == null) {
                    Server server3 = DeployMojo.execute$lambda$0((Lazy<? extends Server>)server$delegate);
                    string = chartRepoPassword = this.decryptPassword(server3 != null ? server3.getPassword() : null);
                }
                if ((mavenProject = this.project) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                    mavenProject = null;
                }
                ChartDeploymentRequest chartDeploymentRequest = new ChartDeploymentRequest(this.chartName, this.chartVersion, this.chartPublishMethod, this.chartRepoUrl, this.chartPublishUrl, this.chartDeleteUrl, chartRepoUsername, chartRepoPassword, this.skipSnapshots, mavenProject);
                if (!this.deployAtEnd && this.skipSnapshots && chartDeploymentRequest.isSnapshotVersion()) {
                    this.getLog().info((CharSequence)"Version contains SNAPSHOT and 'skipSnapshots' option is enabled. Not publishing.");
                    return;
                }
                boolean deployAtEndRequested = false;
                if (this.deployAtEnd) {
                    deployAtEndDeploymentRequests.add(chartDeploymentRequest);
                    deployAtEndRequested = true;
                } else {
                    this.publishToRepo(chartDeploymentRequest);
                }
                int n = readyProjectsCounter.incrementAndGet();
                List<? extends MavenProject> list = this.reactorProjects;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"reactorProjects");
                    list = null;
                }
                boolean bl = projectsReady = n == list.size();
                if (projectsReady) {
                    List<ChartDeploymentRequest> list2 = deployAtEndDeploymentRequests;
                    synchronized (list2) {
                        boolean bl2 = false;
                        Iterable $this$forEach$iv = deployAtEndDeploymentRequests;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ChartDeploymentRequest it = (ChartDeploymentRequest)element$iv;
                            boolean bl3 = false;
                            this.publishToRepo(it);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block16;
                    }
                }
                if (deployAtEndRequested) {
                    this.getLog().info((CharSequence)("Deploy helm chart: " + chartDeploymentRequest.chartName() + " at end."));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error creating/publishing helm chart: " + e.getMessage(), e);
            }
        }
    }

    private final void publishToRepo(ChartDeploymentRequest chartDeploymentRequest) {
        if (!this.chartFileExists(chartDeploymentRequest)) {
            this.getLog().info((CharSequence)("Skip module " + chartDeploymentRequest.chartName() + ". There is no tar file present."));
            return;
        }
        if (chartDeploymentRequest.isSnapshotVersion()) {
            this.removeChartIfExists(chartDeploymentRequest);
        }
        this.publishChart(chartDeploymentRequest);
    }

    private final boolean chartFileExists(ChartDeploymentRequest chartDeploymentRequest) {
        File chartTarGzFile = chartDeploymentRequest.chartTarGzFile();
        this.getLog().debug((CharSequence)("Tar file location: " + chartTarGzFile.getAbsolutePath() + '.'));
        return chartTarGzFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void publishChart(ChartDeploymentRequest chartDeploymentRequest) {
        File chartTarGzFile = chartDeploymentRequest.chartTarGzFile();
        Closeable closeable = (Closeable)this.createChartRepoClient(chartDeploymentRequest);
        Throwable throwable = null;
        try {
            CloseableHttpClient httpClient = (CloseableHttpClient)closeable;
            boolean bl = false;
            HttpUriRequest request = RequestBuilder.create((String)chartDeploymentRequest.getChartPublishMethod()).setUri(chartDeploymentRequest.chartPublishUrl()).setEntity((HttpEntity)new FileEntity(chartTarGzFile)).build();
            Closeable closeable2 = (Closeable)httpClient.execute(request);
            Throwable throwable2 = null;
            try {
                CloseableHttpResponse response = (CloseableHttpResponse)closeable2;
                boolean bl2 = false;
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode >= 300) {
                    throw new RuntimeException("Unexpected status code when executing " + this.chartPublishMethod + " request to chart repo " + chartDeploymentRequest.chartPublishUrl() + ": " + statusCode);
                }
                this.getLog().info((CharSequence)(chartTarGzFile + " uploaded successfully"));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeChartIfExists(ChartDeploymentRequest chartDeploymentRequest) {
        Closeable closeable = (Closeable)this.createChartRepoClient(chartDeploymentRequest);
        Throwable throwable = null;
        try {
            CloseableHttpClient httpClient = (CloseableHttpClient)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)httpClient.execute((HttpUriRequest)new HttpDelete(chartDeploymentRequest.chartDeleteUrl()));
            Throwable throwable2 = null;
            try {
                CloseableHttpResponse response = (CloseableHttpResponse)closeable2;
                boolean bl2 = false;
                if (response.getStatusLine().getStatusCode() == 200) {
                    this.getLog().info((CharSequence)"Existing chart removed successfully");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CloseableHttpClient createChartRepoClient(ChartDeploymentRequest chartDeploymentRequest) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().disableCookieManagement();
        if (chartDeploymentRequest.getChartRepoUsername() != null && chartDeploymentRequest.getChartRepoPassword() != null) {
            void $this$createChartRepoClient_u24lambda_u247;
            BasicCredentialsProvider basicCredentialsProvider;
            BasicCredentialsProvider basicCredentialsProvider2 = basicCredentialsProvider = new BasicCredentialsProvider();
            HttpClientBuilder httpClientBuilder = clientBuilder;
            boolean bl = false;
            $this$createChartRepoClient_u24lambda_u247.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(chartDeploymentRequest.getChartRepoUsername(), chartDeploymentRequest.getChartRepoPassword()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        CloseableHttpClient closeableHttpClient = clientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"clientBuilder.build()");
        return closeableHttpClient;
    }

    @Override
    @Nullable
    public Server getServer(@Nullable String chartRepoServerId) {
        return ServerAuthentication.DefaultImpls.getServer(this, chartRepoServerId);
    }

    @Override
    @Nullable
    public String decryptPassword(@Nullable String password) throws SecDispatcherException {
        return ServerAuthentication.DefaultImpls.decryptPassword(this, password);
    }

    private static final Server execute$lambda$0(Lazy<? extends Server> $server$delegate) {
        Lazy<? extends Server> lazy = $server$delegate;
        return (Server)lazy.getValue();
    }

    public static final /* synthetic */ String access$getChartRepoServerId$p(DeployMojo $this) {
        return $this.chartRepoServerId;
    }

    static {
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf())");
        deployAtEndDeploymentRequests = list;
        readyProjectsCounter = new AtomicInteger();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/deviceinsight/helm/DeployMojo$Companion;", "", "()V", "deployAtEndDeploymentRequests", "", "Lcom/deviceinsight/helm/ChartDeploymentRequest;", "readyProjectsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "helm-maven-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

