/*
 * Decompiled with CFR 0.152.
 */
package com.deviceinsight.helm;

import com.deviceinsight.helm.AbstractHelmMojo;
import com.deviceinsight.helm.ResolveHelmMojo;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/deviceinsight/helm/LintMojo;", "Lcom/deviceinsight/helm/ResolveHelmMojo;", "()V", "skip", "", "strictLint", "valuesFile", "", "execute", "", "helm-maven-plugin"})
@Mojo(name="lint", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class LintMojo
extends ResolveHelmMojo {
    @Parameter(property="valuesFile", required=false)
    @Nullable
    private String valuesFile;
    @Parameter(property="strictLint", defaultValue="false", required=false)
    private boolean strictLint;
    @Parameter(property="helm.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"helm-lint has been skipped");
            return;
        }
        try {
            if (!this.isChartFolderPresent()) {
                this.getLog().warn((CharSequence)"No sources found skipping helm lint.");
                return;
            }
            super.execute();
            Object[] objectArray = new String[]{this.getHelm(), "lint", this.chartName()};
            List command = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.strictLint) {
                command.add("--strict");
            }
            if (this.valuesFile != null) {
                command.add("--values");
                File file = this.getProject().getBasedir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.basedir");
                String string = this.valuesFile;
                Intrinsics.checkNotNull((Object)string);
                String string2 = FilesKt.resolve((File)file, (String)string).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.basedir.resolve(valuesFile!!).absolutePath");
                command.add(this.quoteFilePath(string2));
            }
            AbstractHelmMojo.executeCmd$default(this, command, null, true, null, 10, null);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error rendering helm lint: " + e.getMessage(), e);
        }
    }
}

