/*
 * Decompiled with CFR 0.152.
 */
package com.deviceinsight.helm;

import com.deviceinsight.helm.AbstractHelmMojo;
import com.deviceinsight.helm.PackageMojo;
import com.deviceinsight.helm.ResolveHelmMojo;
import com.deviceinsight.helm.util.ServerAuthentication;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0007\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002J\u001e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)\u00b2\u0006\f\u0010*\u001a\u0004\u0018\u00010+X\u008a\u0084\u0002"}, d2={"Lcom/deviceinsight/helm/PackageMojo;", "Lcom/deviceinsight/helm/ResolveHelmMojo;", "Lcom/deviceinsight/helm/util/ServerAuthentication;", "()V", "addIncubatorRepo", "", "chartRepoPassword", "", "chartRepoServerId", "chartRepoUrl", "chartRepoUsername", "extraValuesFiles", "", "forceAddRepos", "incubatorRepoUrl", "securityDispatcher", "Lorg/sonatype/plexus/components/sec/dispatcher/SecDispatcher;", "getSecurityDispatcher", "()Lorg/sonatype/plexus/components/sec/dispatcher/SecDispatcher;", "setSecurityDispatcher", "(Lorg/sonatype/plexus/components/sec/dispatcher/SecDispatcher;)V", "settings", "Lorg/apache/maven/settings/Settings;", "getSettings", "()Lorg/apache/maven/settings/Settings;", "setSettings", "(Lorg/apache/maven/settings/Settings;)V", "skip", "stableRepoUrl", "ensureChartFileExists", "", "execute", "findPropertyValue", "", "property", "fileName", "mergeValuesFiles", "targetHelmDir", "Ljava/io/File;", "processHelmConfigFiles", "Companion", "helm-maven-plugin", "server", "Lorg/apache/maven/settings/Server;"})
@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
@SourceDebugExtension(value={"SMAP\nPackageMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageMojo.kt\ncom/deviceinsight/helm/PackageMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n766#2:246\n857#2,2:247\n*S KotlinDebug\n*F\n+ 1 PackageMojo.kt\ncom/deviceinsight/helm/PackageMojo\n*L\n202#1:246\n202#1:247,2\n*E\n"})
public final class PackageMojo
extends ResolveHelmMojo
implements ServerAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Component(role=SecDispatcher.class, hint="default")
    public SecDispatcher securityDispatcher;
    @Parameter(property="chartRepoUrl", required=false)
    @Nullable
    private String chartRepoUrl;
    @Parameter(property="helm.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="chartRepoUsername", required=false)
    @Nullable
    private String chartRepoUsername;
    @Parameter(property="chartRepoPassword", required=false)
    @Nullable
    private String chartRepoPassword;
    @Parameter(property="chartRepoServerId", required=false)
    @Nullable
    private String chartRepoServerId;
    @Parameter(property="incubatorRepoUrl", defaultValue="https://charts.helm.sh/incubator")
    @NotNull
    private String incubatorRepoUrl = "https://charts.helm.sh/incubator";
    @Parameter(property="stableRepoUrl", defaultValue="https://charts.helm.sh/stable")
    @NotNull
    private String stableRepoUrl = "https://charts.helm.sh/stable";
    @Parameter(property="addIncubatorRepo", defaultValue="true")
    private boolean addIncubatorRepo = true;
    @Parameter(property="forceAddRepos", defaultValue="false")
    private boolean forceAddRepos;
    @Parameter(defaultValue="${settings}", readonly=true)
    public Settings settings;
    @Parameter(property="extraValuesFiles")
    @NotNull
    private final List<String> extraValuesFiles = CollectionsKt.emptyList();
    @NotNull
    private static final Regex PLACEHOLDER_REGEX = new Regex("\\$\\{(.*?)}");
    @NotNull
    private static final Set<String> SUBSTITUTED_EXTENSIONS;

    @Override
    @NotNull
    public SecDispatcher getSecurityDispatcher() {
        SecDispatcher secDispatcher = this.securityDispatcher;
        if (secDispatcher != null) {
            return secDispatcher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"securityDispatcher");
        return null;
    }

    public void setSecurityDispatcher(@NotNull SecDispatcher secDispatcher) {
        Intrinsics.checkNotNullParameter((Object)secDispatcher, (String)"<set-?>");
        this.securityDispatcher = secDispatcher;
    }

    @Override
    @NotNull
    public Settings getSettings() {
        Settings settings = this.settings;
        if (settings != null) {
            return settings;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        return null;
    }

    public void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.settings = settings;
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"helm-package has been skipped");
            return;
        }
        try {
            Object[] objectArray;
            List helmAddFlags;
            if (!this.isChartFolderPresent()) {
                this.getLog().warn((CharSequence)"No sources found skipping helm package.");
                return;
            }
            super.execute();
            File targetHelmDir = new File(this.target(), this.chartName());
            boolean isHelm2 = this.majorHelmVersion() < 3;
            this.getLog().info((CharSequence)"Clear target directory to ensure clean target package");
            if (targetHelmDir.exists()) {
                FilesKt.deleteRecursively((File)targetHelmDir);
            }
            targetHelmDir.mkdirs();
            this.getLog().info((CharSequence)"Created target helm directory");
            this.processHelmConfigFiles(targetHelmDir);
            this.mergeValuesFiles(targetHelmDir, this.extraValuesFiles);
            List list = helmAddFlags = isHelm2 || !this.forceAddRepos ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)"--force-update");
            if (isHelm2) {
                objectArray = new String[]{this.getHelm(), "init", "--client-only", "--stable-repo-url", this.stableRepoUrl};
                AbstractHelmMojo.executeCmd$default(this, CollectionsKt.listOf((Object[])objectArray), null, false, null, 14, null);
            }
            if (this.addIncubatorRepo) {
                objectArray = new String[]{this.getHelm(), "repo", "add", "incubator", this.incubatorRepoUrl};
                AbstractHelmMojo.executeCmd$default(this, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)helmAddFlags), null, false, null, 14, null);
            }
            if (this.chartRepoUrl != null) {
                List list2;
                Object[] objectArray2;
                String chartRepoPassword;
                String string;
                String chartRepoUsername;
                Lazy server$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Server>(this){
                    final /* synthetic */ PackageMojo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Server invoke() {
                        return this.this$0.getServer(PackageMojo.access$getChartRepoServerId$p(this.this$0));
                    }
                }));
                String string2 = this.chartRepoUsername;
                if (string2 == null) {
                    Server server2 = PackageMojo.execute$lambda$0((Lazy<? extends Server>)server$delegate);
                    string2 = chartRepoUsername = server2 != null ? server2.getUsername() : null;
                }
                if ((string = this.chartRepoPassword) == null) {
                    Server server3 = PackageMojo.execute$lambda$0((Lazy<? extends Server>)server$delegate);
                    string = chartRepoPassword = this.decryptPassword(server3 != null ? server3.getPassword() : null);
                }
                if (chartRepoUsername != null && chartRepoPassword != null) {
                    objectArray2 = new String[]{"--username", chartRepoUsername, "--password", chartRepoPassword};
                    list2 = CollectionsKt.listOf((Object[])objectArray2);
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List authParams = list2;
                AbstractHelmMojo abstractHelmMojo = this;
                objectArray2 = new String[5];
                objectArray2[0] = this.getHelm();
                objectArray2[1] = "repo";
                objectArray2[2] = "add";
                objectArray2[3] = "chartRepo";
                Intrinsics.checkNotNull((Object)this.chartRepoUrl);
                AbstractHelmMojo.executeCmd$default(abstractHelmMojo, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray2), (Iterable)authParams), (Iterable)helmAddFlags), null, false, null, 14, null);
            }
            objectArray = new String[]{this.getHelm(), "dependency", "update"};
            AbstractHelmMojo.executeCmd$default(this, CollectionsKt.listOf((Object[])objectArray), targetHelmDir, false, null, 12, null);
            objectArray = new String[]{this.getHelm(), "package", this.chartName(), "--version", this.getChartVersion()};
            AbstractHelmMojo.executeCmd$default(this, CollectionsKt.listOf((Object[])objectArray), null, false, null, 14, null);
            this.ensureChartFileExists();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating helm chart: " + e.getMessage(), e);
        }
    }

    private final void ensureChartFileExists() {
        File chartTarGzFile = this.chartTarGzFile();
        if (!chartTarGzFile.exists()) {
            throw new RuntimeException("File " + chartTarGzFile.getAbsolutePath() + " not found. Chart must be created in package phase first.");
        }
        this.getLog().info((CharSequence)("Successfully packaged chart and saved it to: " + chartTarGzFile));
    }

    private final void processHelmConfigFiles(File targetHelmDir) {
        File directory = new File(this.getProject().getBasedir() + '/' + this.chartFolder());
        this.getLog().debug((CharSequence)("Processing helm files in directory " + directory.getAbsolutePath()));
        List processedFiles2 = SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)directory)), (Function1)processHelmConfigFiles.processedFiles.1.INSTANCE), (Function1)((Function1)new Function1<File, Unit>(this, targetHelmDir, directory){
            final /* synthetic */ PackageMojo this$0;
            final /* synthetic */ File $targetHelmDir;
            final /* synthetic */ File $directory;
            {
                this.this$0 = $receiver;
                this.$targetHelmDir = $targetHelmDir;
                this.$directory = $directory;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.this$0.getLog().debug((CharSequence)("Processing helm file " + file.getAbsolutePath()));
                File targetFile = FilesKt.resolve((File)this.$targetHelmDir, (String)FilesKt.toRelativeString((File)file, (File)this.$directory));
                this.this$0.getLog().debug((CharSequence)("Copying to " + targetFile.getAbsolutePath()));
                Object object = targetFile;
                File $this$invoke_u24lambda_u240 = object;
                boolean bl = false;
                $this$invoke_u24lambda_u240.getParentFile().mkdirs();
                Set set = PackageMojo.access$getSUBSTITUTED_EXTENSIONS$cp();
                String string = FilesKt.getExtension((File)file).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!set.contains(string)) {
                    FilesKt.copyTo$default((File)file, (File)targetFile, (boolean)true, (int)0, (int)4, null);
                    return;
                }
                object = targetFile;
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                Object object3 = object;
                object = (object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                object2 = this.this$0;
                Throwable throwable = null;
                try {
                    void $this$useLines$iv$iv;
                    BufferedWriter writer = (BufferedWriter)object;
                    boolean bl2 = false;
                    File $this$useLines_u24default$iv = file;
                    Charset charset$iv = Charsets.UTF_8;
                    File file2 = $this$useLines_u24default$iv;
                    Charset charset$iv$iv = charset$iv;
                    boolean $i$f$useLines = false;
                    Closeable closeable = $this$useLines$iv$iv;
                    int n2 = 8192;
                    Reader reader = closeable;
                    reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), charset$iv$iv);
                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
                    Throwable throwable2 = null;
                    try {
                        void $this$forEach$iv;
                        BufferedReader it$iv$iv = (BufferedReader)closeable;
                        boolean bl3 = false;
                        Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                        boolean bl4 = false;
                        Sequence sequence = SequencesKt.map((Sequence)lines, (Function1)((Function1)new Function1<String, String>((PackageMojo)object2, targetFile){
                            final /* synthetic */ PackageMojo this$0;
                            final /* synthetic */ File $targetFile;
                            {
                                this.this$0 = $receiver;
                                this.$targetFile = $targetFile;
                                super(1);
                            }

                            @NotNull
                            public final String invoke(@NotNull String line) {
                                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                return PackageMojo.access$getPLACEHOLDER_REGEX$cp().replace((CharSequence)line, (Function1)new Function1<MatchResult, CharSequence>(this.this$0, this.$targetFile){
                                    final /* synthetic */ PackageMojo this$0;
                                    final /* synthetic */ File $targetFile;
                                    {
                                        this.this$0 = $receiver;
                                        this.$targetFile = $targetFile;
                                        super(1);
                                    }

                                    @NotNull
                                    public final CharSequence invoke(@NotNull MatchResult matchResult) {
                                        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                                        String property = (String)matchResult.getGroupValues().get(1);
                                        String string = this.$targetFile.getAbsolutePath();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetFile.absolutePath");
                                        CharSequence propertyValue = PackageMojo.access$findPropertyValue(this.this$0, property, string);
                                        CharSequence charSequence = propertyValue;
                                        if (charSequence == null) {
                                            charSequence = (CharSequence)matchResult.getGroupValues().get(0);
                                        }
                                        return charSequence;
                                    }
                                });
                            }
                        }));
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            Appendable appendable = ((Appendable)writer).append(it);
                            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
                            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
                        }
                        reader = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    object3 = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        })));
        if (processedFiles2.isEmpty()) {
            throw new IllegalStateException("No helm files found in " + directory.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeValuesFiles(File targetHelmDir, List<String> extraValuesFiles) {
        void $this$filterTo$iv$iv;
        if (extraValuesFiles.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = extraValuesFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!new File(it).exists())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingFiles = (List)destination$iv$iv;
        if (!((Collection)missingFiles).isEmpty()) {
            throw new IllegalStateException("extraValueFiles not found: " + missingFiles);
        }
        List allValuesFiles = CollectionsKt.toMutableList((Collection)extraValuesFiles);
        File valuesFile = FilesKt.resolve((File)targetHelmDir, (String)"values.yaml");
        if (valuesFile.exists()) {
            String string = valuesFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valuesFile.absolutePath");
            allValuesFiles.add(0, string);
        }
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));
        ObjectNode objectNode = yamlMapper.createObjectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"yamlMapper.createObjectNode()");
        ObjectNode values = objectNode;
        ObjectReader yamlReader = yamlMapper.setDefaultMergeable(Boolean.valueOf(true)).readerForUpdating((Object)values);
        try {
            for (String file : allValuesFiles) {
                yamlReader.readValue(new File(file), ObjectNode.class);
            }
            yamlMapper.writeValue(valuesFile, (Object)values);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final CharSequence findPropertyValue(String property, String fileName) {
        String result;
        String string = property;
        String string2 = Intrinsics.areEqual((Object)string, (Object)"project.version") ? this.getProject().getVersion() : (Intrinsics.areEqual((Object)string, (Object)"artifactId") ? this.getProject().getArtifactId() : (Intrinsics.areEqual((Object)string, (Object)"project.name") ? this.getProject().getName() : (result = System.getProperties().keySet().contains(string) ? System.getProperty(property) : this.getProject().getProperties().getProperty(property))));
        if (result == null) {
            this.getLog().warn((CharSequence)("Could not resolve property: '" + property + "' used in file: '" + fileName + '\''));
        } else {
            this.getLog().debug((CharSequence)("Resolved property: '" + property + "' as: '" + result + '\''));
        }
        return result;
    }

    @Override
    @Nullable
    public Server getServer(@Nullable String chartRepoServerId) {
        return ServerAuthentication.DefaultImpls.getServer(this, chartRepoServerId);
    }

    @Override
    @Nullable
    public String decryptPassword(@Nullable String password) throws SecDispatcherException {
        return ServerAuthentication.DefaultImpls.decryptPassword(this, password);
    }

    private static final Server execute$lambda$0(Lazy<? extends Server> $server$delegate) {
        Lazy<? extends Server> lazy = $server$delegate;
        return (Server)lazy.getValue();
    }

    public static final /* synthetic */ String access$getChartRepoServerId$p(PackageMojo $this) {
        return $this.chartRepoServerId;
    }

    public static final /* synthetic */ Set access$getSUBSTITUTED_EXTENSIONS$cp() {
        return SUBSTITUTED_EXTENSIONS;
    }

    public static final /* synthetic */ Regex access$getPLACEHOLDER_REGEX$cp() {
        return PLACEHOLDER_REGEX;
    }

    public static final /* synthetic */ CharSequence access$findPropertyValue(PackageMojo $this, String property, String fileName) {
        return $this.findPropertyValue(property, fileName);
    }

    static {
        Object[] objectArray = new String[]{"json", "tpl", "yml", "yaml"};
        SUBSTITUTED_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/deviceinsight/helm/PackageMojo$Companion;", "", "()V", "PLACEHOLDER_REGEX", "Lkotlin/text/Regex;", "SUBSTITUTED_EXTENSIONS", "", "", "helm-maven-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

