/*
 * Decompiled with CFR 0.152.
 */
package com.deviceinsight.helm;

import com.deviceinsight.helm.AbstractHelmMojo;
import com.deviceinsight.helm.ResolveHelmMojo;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/deviceinsight/helm/TemplateMojo;", "Lcom/deviceinsight/helm/ResolveHelmMojo;", "()V", "outputFile", "", "skip", "", "valuesFile", "execute", "", "helm-maven-plugin"})
@Mojo(name="template", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class TemplateMojo
extends ResolveHelmMojo {
    @Parameter(property="valuesFile", required=false)
    @Nullable
    private String valuesFile;
    @Parameter(property="outputFile", defaultValue="${project.build.directory}/test-classes/helm.yaml")
    private String outputFile;
    @Parameter(property="helm.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"helm-template has been skipped");
            return;
        }
        try {
            File file;
            String string;
            List command;
            List list;
            Object[] valuesFilePath;
            if (!this.isChartFolderPresent()) {
                this.getLog().warn((CharSequence)"No sources found, skipping helm template.");
                return;
            }
            super.execute();
            if (this.valuesFile != null) {
                File file2 = this.getProject().getBasedir();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.basedir");
                String string2 = this.valuesFile;
                Intrinsics.checkNotNull((Object)string2);
                valuesFilePath = FilesKt.resolve((File)file2, (String)string2).getAbsolutePath();
                Object[] objectArray = new String[]{this.getHelm(), "template", "--values", valuesFilePath, this.chartName()};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                valuesFilePath = new String[]{this.getHelm(), "template", this.chartName()};
                list = command = CollectionsKt.listOf((Object[])valuesFilePath);
            }
            if ((string = this.outputFile) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
                string = null;
            }
            if (!(file = new File(string)).isAbsolute()) {
                File file3 = this.getProject().getBasedir();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.basedir");
                file = FilesKt.resolve((File)file3, (File)file);
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            AbstractHelmMojo abstractHelmMojo = this;
            ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.to(file);
            Intrinsics.checkNotNullExpressionValue((Object)redirect, (String)"to(file)");
            AbstractHelmMojo.executeCmd$default(abstractHelmMojo, command, null, false, redirect, 6, null);
            this.getLog().info((CharSequence)("Rendered helm template to '" + file.getAbsolutePath() + '\''));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error rendering helm templates: " + e.getMessage(), e);
        }
    }
}

