/*
 * Decompiled with CFR 0.152.
 */
package com.deviceinsight.helm.util;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/deviceinsight/helm/util/PlatformDetector;", "", "()V", "IGNORED_CHARACTERS", "Lkotlin/text/Regex;", "detectHelmReleasePlatformIdentifier", "", "determineOperatingSystem", "determinePlatformArchitecture", "normalizeIdentifier", "identifier", "helm-maven-plugin"})
public final class PlatformDetector {
    @NotNull
    public static final PlatformDetector INSTANCE = new PlatformDetector();
    @NotNull
    private static final Regex IGNORED_CHARACTERS = new Regex("[^a-z0-9_]");

    private PlatformDetector() {
    }

    @NotNull
    public final String detectHelmReleasePlatformIdentifier() {
        String os = this.determineOperatingSystem();
        String arch = this.determinePlatformArchitecture();
        return os + '-' + arch;
    }

    private final String determineOperatingSystem() {
        String string;
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.name\")");
        String osName = this.normalizeIdentifier(string2);
        if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            string = "windows";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"osx", (boolean)false, (int)2, null)) {
            string = "darwin";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null)) {
            string = "linux";
        } else {
            throw new IllegalStateException("Unsupported OS '" + System.getProperty("os.name") + '\'');
        }
        return string;
    }

    private final String determinePlatformArchitecture() {
        String string;
        String string2 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.arch\")");
        String osArch = this.normalizeIdentifier(string2);
        if (Intrinsics.areEqual((Object)osArch, (Object)"x86_64") || Intrinsics.areEqual((Object)osArch, (Object)"amd64")) {
            string = "amd64";
        } else if (Intrinsics.areEqual((Object)osArch, (Object)"x86") || Intrinsics.areEqual((Object)osArch, (Object)"i386")) {
            string = "386";
        } else if (Intrinsics.areEqual((Object)osArch, (Object)"aarch32") || StringsKt.startsWith$default((String)osArch, (String)"arm", (boolean)false, (int)2, null)) {
            string = "arm";
        } else if (Intrinsics.areEqual((Object)osArch, (Object)"aarch64") || StringsKt.contains$default((CharSequence)osArch, (CharSequence)"arm64", (boolean)false, (int)2, null)) {
            string = "arm64";
        } else if (StringsKt.contains$default((CharSequence)osArch, (CharSequence)"ppc64le", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osArch, (CharSequence)"ppc64", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)System.getProperty("sun.cpu.endian"), (Object)"little")) {
            string = "ppc64le";
        } else {
            throw new IllegalStateException("Unsupported platform architecture '" + System.getProperty("os.arch") + '\'');
        }
        return string;
    }

    private final String normalizeIdentifier(String identifier) {
        CharSequence charSequence = identifier;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string = charSequence.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        charSequence = string;
        Regex regex = IGNORED_CHARACTERS;
        String string2 = "";
        return regex.replace(charSequence, string2);
    }
}

