/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer;

import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.TimeProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DateProducer {
    @VisibleForTesting
    static final int SECONDS_BEFORE_TO_BE_IN_THE_PAST = 1;
    private final BaseProducer baseProducer;
    private final TimeProvider timeProvider;

    @Inject
    public DateProducer(BaseProducer baseProducer, TimeProvider timeProvider) {
        this.baseProducer = baseProducer;
        this.timeProvider = timeProvider;
    }

    public LocalDateTime randomDateInThePast(int maxYearsEarlier) {
        Preconditions.checkArgument((maxYearsEarlier >= 0 ? 1 : 0) != 0, (String)"%s has to be >= 0", (int)maxYearsEarlier);
        LocalDateTime currentDate = this.timeProvider.getCurrentTime();
        LocalDateTime latestDateInThePast = currentDate.minusSeconds(1L);
        LocalDateTime maxYearsEarlierDate = currentDate.minusYears(maxYearsEarlier);
        return this.randomDateBetweenTwoDates(maxYearsEarlierDate, latestDateInThePast);
    }

    public LocalDateTime randomDateBetweenYearAndNow(int fromYear) {
        int actualYear = this.timeProvider.getCurrentYear();
        return this.randomDateInThePast(actualYear - fromYear);
    }

    public LocalDate randomDateBetweenTwoDates(LocalDate from, LocalDate to) {
        long epochDay = this.baseProducer.randomBetween(from.toEpochDay(), to.toEpochDay());
        return LocalDate.ofEpochDay(epochDay);
    }

    public LocalDateTime randomDateBetweenTwoDates(LocalDateTime from, LocalDateTime to) {
        long between = this.baseProducer.randomBetween(from.toInstant(ZoneOffset.UTC).toEpochMilli(), to.toInstant(ZoneOffset.UTC).toEpochMilli());
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(between), ZoneOffset.UTC);
    }

    public LocalDateTime randomDateBetweenYears(int fromYear, int toYear) {
        Preconditions.checkArgument((fromYear <= toYear ? 1 : 0) != 0, (String)"%s has to be <= %s", (int)fromYear, (int)toYear);
        LocalDateTime fromDate = this.getDateForFirstDayForGivenYear(fromYear);
        LocalDateTime toDate = this.getDateForLastDayForGivenYear(toYear);
        return this.randomDateBetweenTwoDates(fromDate, toDate);
    }

    private LocalDateTime getDateForLastDayForGivenYear(int year) {
        return LocalDateTime.of(year, Month.JANUARY, 1, 23, 59).with(TemporalAdjusters.lastDayOfYear());
    }

    private LocalDateTime getDateForFirstDayForGivenYear(int year) {
        return LocalDateTime.of(year, Month.JANUARY, 1, 0, 0).with(TemporalAdjusters.firstDayOfYear());
    }

    public LocalDateTime randomDateBetweenNowAndFuturePeriod(Period futurePeriod) {
        LocalDateTime now = this.timeProvider.getCurrentTime();
        return this.randomDateBetweenTwoDates(now, now.plus(futurePeriod));
    }

    public LocalDateTime randomDateInTheFuture(int years) {
        return this.randomDateBetweenNowAndFuturePeriod(Period.ofYears(years));
    }

    public LocalDateTime randomDateInTheFuture() {
        return this.randomDateInTheFuture(100);
    }
}

