/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.company.locale.es;

import com.devskiller.jfairy.producer.VATIdentificationNumberProvider;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;

public class EsVATIdentificationNumberProvider
implements VATIdentificationNumberProvider {
    private static final String REGEX_CIF = "^[A-Z][0-9]{2}[0-9]{5}([KPQSABEH]|[0-9]|[A-Z])$";
    private Pattern regexCif = Pattern.compile("^[A-Z][0-9]{2}[0-9]{5}([KPQSABEH]|[0-9]|[A-Z])$");

    @Override
    public String get() {
        return String.format("%s%s%s", RandomStringUtils.randomAlphabetic((int)1).toUpperCase(), RandomStringUtils.randomNumeric((int)7), RandomStringUtils.randomAlphanumeric((int)1).toUpperCase());
    }

    public boolean isValid(String cif) {
        return this.regexCif.matcher(cif).matches();
    }
}

