/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.person;

import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.person.AddressProvider;

public abstract class AbstractAddressProvider
implements AddressProvider {
    private static final String POSTAL_CODE_FORMAT = "postal_code";
    private static final String CITY = "city";
    private static final String STREET = "street";
    protected final BaseProducer baseProducer;
    protected final DataMaster dataMaster;

    public AbstractAddressProvider(DataMaster dataMaster, BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
        this.dataMaster = dataMaster;
    }

    public String getCity() {
        return this.dataMaster.getRandomValue(CITY);
    }

    public String getPostalCode() {
        String postalCodeFormat = this.dataMaster.getRandomValue(POSTAL_CODE_FORMAT);
        return this.baseProducer.numerify(postalCodeFormat);
    }

    public String getStreet() {
        return this.dataMaster.getRandomValue(STREET);
    }

    public String getStreetNumber() {
        return String.valueOf(this.baseProducer.randomBetween(1, 199));
    }

    public String getApartmentNumber() {
        return this.baseProducer.trueOrFalse() ? String.valueOf(this.baseProducer.randomBetween(1, 350)) : "";
    }
}

