/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy;

import com.devskiller.jfairy.Bootstrap;
import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.DateProducer;
import com.devskiller.jfairy.producer.company.Company;
import com.devskiller.jfairy.producer.company.CompanyFactory;
import com.devskiller.jfairy.producer.company.CompanyProperties;
import com.devskiller.jfairy.producer.net.NetworkProducer;
import com.devskiller.jfairy.producer.payment.CreditCard;
import com.devskiller.jfairy.producer.payment.CreditCardProvider;
import com.devskiller.jfairy.producer.payment.IBAN;
import com.devskiller.jfairy.producer.payment.IBANFactory;
import com.devskiller.jfairy.producer.payment.IBANProperties;
import com.devskiller.jfairy.producer.person.Person;
import com.devskiller.jfairy.producer.person.PersonFactory;
import com.devskiller.jfairy.producer.person.PersonProperties;
import com.devskiller.jfairy.producer.text.TextProducer;
import com.google.inject.Provider;
import java.util.Locale;
import javax.inject.Inject;

public final class Fairy {
    private final TextProducer textProducer;
    private final PersonFactory personFactory;
    private final NetworkProducer networkProducer;
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;
    private final CreditCardProvider creditCardProvider;
    private final CompanyFactory companyFactory;
    private final IBANFactory ibanFactory;

    @Inject
    Fairy(TextProducer textProducer, PersonFactory personFactory, NetworkProducer networkProducer, BaseProducer baseProducer, DateProducer dateProducer, CreditCardProvider creditCardProvider, CompanyFactory companyFactory, IBANFactory ibanFactory) {
        this.textProducer = textProducer;
        this.personFactory = personFactory;
        this.networkProducer = networkProducer;
        this.baseProducer = baseProducer;
        this.dateProducer = dateProducer;
        this.creditCardProvider = creditCardProvider;
        this.companyFactory = companyFactory;
        this.ibanFactory = ibanFactory;
    }

    public static Fairy create() {
        return Bootstrap.create();
    }

    public static Fairy create(Locale locale) {
        return Bootstrap.create(locale);
    }

    public static Fairy create(Provider<DataMaster> dataMasterProvider, Locale locale) {
        return Bootstrap.create(dataMasterProvider, locale);
    }

    public static Bootstrap.Builder builder() {
        return Bootstrap.builder();
    }

    public TextProducer textProducer() {
        return this.textProducer;
    }

    public Person person(PersonProperties.PersonProperty ... personProperties) {
        return this.personFactory.producePersonProvider(personProperties).get();
    }

    public Company company(CompanyProperties.CompanyProperty ... companyProperties) {
        return this.companyFactory.produceCompany(companyProperties).get();
    }

    public BaseProducer baseProducer() {
        return this.baseProducer;
    }

    public DateProducer dateProducer() {
        return this.dateProducer;
    }

    public IBAN iban() {
        return this.ibanFactory.produceIBANProvider(new IBANProperties.Property[0]).get();
    }

    public IBAN iban(IBANProperties.Property ... properties) {
        return this.ibanFactory.produceIBANProvider(properties).get();
    }

    public CreditCard creditCard() {
        return this.creditCardProvider.get();
    }

    public NetworkProducer networkProducer() {
        return this.networkProducer;
    }
}

