/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy;

import com.devskiller.jfairy.FairyFactory;
import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.RandomGenerator;
import com.devskiller.jfairy.producer.company.CompanyFactory;
import com.devskiller.jfairy.producer.company.CompanyProvider;
import com.devskiller.jfairy.producer.company.DefaultCompanyProvider;
import com.devskiller.jfairy.producer.payment.DefaultIBANProvider;
import com.devskiller.jfairy.producer.payment.IBANFactory;
import com.devskiller.jfairy.producer.payment.IBANProvider;
import com.devskiller.jfairy.producer.person.DefaultPersonProvider;
import com.devskiller.jfairy.producer.person.PersonFactory;
import com.devskiller.jfairy.producer.person.PersonProvider;
import com.google.inject.AbstractModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;

public abstract class FairyModule
extends AbstractModule {
    private final RandomGenerator randomGenerator;
    private final DataMaster dataMaster;

    public FairyModule(DataMaster dataMaster, RandomGenerator randomGenerator) {
        this.dataMaster = dataMaster;
        this.randomGenerator = randomGenerator;
    }

    protected void configure() {
        this.bind(DataMaster.class).toInstance((Object)this.dataMaster);
        this.bind(RandomGenerator.class).toInstance((Object)this.randomGenerator);
        this.install(new FactoryModuleBuilder().build(FairyFactory.class));
        this.install(new FactoryModuleBuilder().implement(PersonProvider.class, DefaultPersonProvider.class).build(PersonFactory.class));
        this.install(new FactoryModuleBuilder().implement(CompanyProvider.class, DefaultCompanyProvider.class).build(CompanyFactory.class));
        this.install(new FactoryModuleBuilder().implement(IBANProvider.class, DefaultIBANProvider.class).build(IBANFactory.class));
    }
}

