/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.data;

import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.util.LanguageCode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.EnumUtils;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public class MapBasedDataMaster
implements DataMaster {
    public static final String LANGUAGE_TAG = "language";
    private final BaseProducer baseProducer;
    private Map<String, Object> dataSource = new CaseInsensitiveMap();

    @Inject
    public MapBasedDataMaster(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
    }

    @Override
    public List<String> getStringList(String key) {
        return this.getData(key, List.class);
    }

    @Override
    public <T> T getValuesOfType(String dataKey, String type, Class<T> resultClass) {
        Map data = this.getData(dataKey, Map.class);
        List entries = (List)data.get(type);
        return this.baseProducer.randomElement(entries);
    }

    @Override
    public String getString(String key) {
        return this.getData(key, String.class);
    }

    @Override
    public String getRandomValue(String key) {
        return this.baseProducer.randomElement(this.getStringList(key));
    }

    @Override
    public LanguageCode getLanguage() {
        return (LanguageCode)EnumUtils.getEnum(LanguageCode.class, (String)this.getString(LANGUAGE_TAG).toUpperCase());
    }

    <T> T getData(String key, Class<T> type) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Object element = this.dataSource.get(key);
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (String)"No such key: %s", (Object)key);
        Preconditions.checkArgument((boolean)type.isAssignableFrom(element.getClass()), (String)"Element under desired key has incorrect type - should be %s", (Object)type.getSimpleName());
        return (T)element;
    }

    public void readResources(String path) throws IOException {
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(path);
        if (!resources.hasMoreElements()) {
            throw new IllegalArgumentException(String.format("File %s was not found on classpath", path));
        }
        LoadSettings loadSettings = LoadSettings.builder().build();
        while (resources.hasMoreElements()) {
            Load load = new Load(loadSettings);
            URL url = resources.nextElement();
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                Map data = (Map)load.loadFromInputStream(is);
                this.appendData(data);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private void appendData(Map<String, Object> data) {
        this.dataSource.putAll(data);
    }

    private static class CaseInsensitiveMap
    extends HashMap<String, Object> {
        private CaseInsensitiveMap() {
        }

        @Override
        public Object put(String key, Object value) {
            String loweredKey = key.toLowerCase();
            Object valueToInsert = value;
            if (value instanceof Map) {
                valueToInsert = new CaseInsensitiveMap();
                ((CaseInsensitiveMap)valueToInsert).putAll((Map)value);
            }
            return super.put(loweredKey, valueToInsert);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object get(Object key) {
            return super.get(((String)key).toLowerCase());
        }
    }
}

