/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.company.locale.en;

import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.VATIdentificationNumberProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EnVATIdentificationNumberProvider
implements VATIdentificationNumberProvider {
    private static final int EIN_LENGTH = 10;
    private static final int HYPHEN_INDEX = 2;
    private static final int SERIAL_NUMBER_LENGTH = 7;
    private static final int SERIAL_NUMBER_INDEX = 3;
    private static final int AREA_NUMBER_LENGTH = 2;
    private BaseProducer baseProducer;
    private static Set<Integer> excludedNumbers = Sets.newHashSet((Object[])new Integer[]{7, 8, 9, 17, 18, 19, 28, 29, 41, 47, 49, 69, 70, 79, 89, 96, 97});

    @Inject
    public EnVATIdentificationNumberProvider(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
    }

    @Override
    public String get() {
        char[] ein = new char[10];
        this.fillHyphen(ein);
        this.fillAreaNumber(ein);
        this.fillSerialNumber(ein);
        return String.valueOf(ein);
    }

    private void fillSerialNumber(char[] ein) {
        String number = String.valueOf(this.baseProducer.randomBetween(1, 9999));
        char[] digits = StringUtils.leftPad((String)number, (int)7, (String)"0").toCharArray();
        System.arraycopy(digits, 0, ein, 3, digits.length);
    }

    private void fillAreaNumber(char[] ein) {
        Integer number;
        while (excludedNumbers.contains(number = Integer.valueOf(this.baseProducer.randomBetween(0, 99)))) {
        }
        char[] digits = StringUtils.leftPad((String)number.toString(), (int)2, (String)"0").toCharArray();
        System.arraycopy(digits, 0, ein, 0, digits.length);
    }

    private void fillHyphen(char[] ein) {
        ein[2] = 45;
    }
}

