/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.person.locale.pl;

import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.DateProducer;
import com.devskiller.jfairy.producer.person.NationalIdentityCardNumberProvider;
import com.devskiller.jfairy.producer.util.AlphaNumberSystem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.LocalDate;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class PlNationalIdentityCardNumberProvider
implements NationalIdentityCardNumberProvider {
    @VisibleForTesting
    static final int ISSUING_BEGIN = 2000;
    private static final int[] WEIGHTS = new int[]{7, 3, 1, 0, 7, 3, 1, 7, 3};
    private static final int CHECKSUM_INDEX = 3;
    private static final int DIGITS_PART_SIZE = 5;
    @VisibleForTesting
    static final int MAX_DIGITS_PART_VALUE = 99999;
    @VisibleForTesting
    static final int LETTER_WEIGHT = 45;
    private static final int LETTERS_PART_SIZE = 3;
    private static final int LETTER_VALUE_MODIFIER = 10;
    private static final int ALPHABET_SIZE = 26;
    private static final int BASE_TEN = 10;
    private final DateProducer dateProducer;
    private final BaseProducer baseProducer;

    @Inject
    public PlNationalIdentityCardNumberProvider(DateProducer dateProducer, BaseProducer baseProducer) {
        this.dateProducer = dateProducer;
        this.baseProducer = baseProducer;
    }

    @Override
    public String get() {
        LocalDate dateTime = this.dateProducer.randomDateBetweenYearAndNow(2000).toLocalDate();
        return this.get(dateTime);
    }

    public String get(LocalDate date) {
        char checksum;
        Preconditions.checkArgument((date.getYear() >= 2000 ? 1 : 0) != 0, (Object)"Polish ID was introduced in 2000");
        char[] id = new char[WEIGHTS.length];
        this.fillLettersPart(date.getYear(), id);
        this.fillDigitsPart(id);
        id[3] = checksum = this.calculateChecksum(id);
        return String.copyValueOf(id);
    }

    public boolean isValid(String id) {
        char checksum = this.calculateChecksum(id.toCharArray());
        return id.charAt(3) == checksum;
    }

    private char calculateChecksum(char[] id) {
        int index = 0;
        int checksum = 0;
        for (int weight : WEIGHTS) {
            int value = 0;
            if (index < 3) {
                value = id[index] - 65 + 10;
            } else if (index > 3) {
                value = id[index] - 48;
            }
            ++index;
            checksum += weight * value;
        }
        return String.valueOf(checksum % 10).charAt(0);
    }

    private void fillDigitsPart(char[] id) {
        String num = String.valueOf(this.baseProducer.randomInt(99999));
        char[] digits = StringUtils.leftPad((String)num, (int)5, (char)'0').toCharArray();
        System.arraycopy(digits, 0, id, 4, digits.length);
    }

    private void fillLettersPart(int year, char[] id) {
        int maxPrefix = (year - 2000) * 45;
        int range = this.baseProducer.randomBetween(maxPrefix, maxPrefix + 45);
        String prefix = AlphaNumberSystem.convertToString(range, 26);
        char[] charArray = StringUtils.leftPad((String)prefix, (int)3, (char)'A').toCharArray();
        System.arraycopy(charArray, 0, id, 0, charArray.length);
    }
}

