/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.person.locale.pl;

import com.devskiller.jfairy.producer.person.PassportNumberProvider;
import com.devskiller.jfairy.producer.util.AlphaNumberSystem;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

public class PlPassportNumberProvider
implements PassportNumberProvider {
    private static final int CHECKSUM_INDEX = 2;
    private static final int[] WEIGHTS = new int[]{7, 3, 9, 1, 7, 3, 1, 7, 3};
    private List<String> alphabet = AlphaNumberSystem.generateAlphabetList();
    private static Map<String, Integer> letterDigits = null;

    public PlPassportNumberProvider() {
        letterDigits = this.generateLetterDigits();
    }

    private Map<String, Integer> generateLetterDigits() {
        Integer baseNum = 10;
        HashMap letterDigits = Maps.newHashMap();
        for (String letter : this.alphabet) {
            Integer n = baseNum;
            Integer n2 = baseNum = Integer.valueOf(baseNum + 1);
            letterDigits.put(letter, n);
        }
        return letterDigits;
    }

    @Override
    public String get() {
        char[] passport = new char[9];
        this.fillSeries(passport);
        this.fillDigits(passport);
        this.fillChecksum(passport);
        return String.valueOf(passport);
    }

    private void fillChecksum(char[] passport) {
        Integer checkSumValue;
        int i;
        Integer checkSum = 0;
        for (i = 0; i < 2; ++i) {
            checkSumValue = letterDigits.get(String.valueOf(passport[i]));
            checkSum = checkSum + checkSumValue * WEIGHTS[i];
        }
        for (i = 3; i < 9; ++i) {
            checkSumValue = Character.getNumericValue(passport[i]);
            checkSum = checkSum + checkSumValue * WEIGHTS[i];
        }
        passport[2] = Integer.toString(checkSum % 10).charAt(0);
    }

    private void fillSeries(char[] passport) {
        char[] randomSeries = RandomStringUtils.randomAlphabetic((int)2).toUpperCase().toCharArray();
        System.arraycopy(randomSeries, 0, passport, 0, randomSeries.length);
    }

    private void fillDigits(char[] passport) {
        char[] randomDigits = RandomStringUtils.randomNumeric((int)6).toCharArray();
        System.arraycopy(randomDigits, 0, passport, 3, randomDigits.length);
    }

    public static Boolean passportCheckSumIsValid(String passportNumber) {
        Integer checkSumValue;
        int i;
        char[] passport = passportNumber.toCharArray();
        int checkSum = 0;
        for (i = 0; i < 2; ++i) {
            checkSumValue = letterDigits.get(String.valueOf(passport[i]));
            checkSum += checkSumValue * WEIGHTS[i];
        }
        for (i = 2; i < 9; ++i) {
            checkSumValue = Character.getNumericValue(passport[i]);
            checkSum += checkSumValue * WEIGHTS[i];
        }
        return checkSum % 10 == 0;
    }
}

