/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.person.locale.zh;

import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.DateProducer;
import com.devskiller.jfairy.producer.TimeProvider;
import com.devskiller.jfairy.producer.person.NationalIdentityCardNumberProvider;
import com.devskiller.jfairy.producer.util.ZhFairyUtil;
import com.google.inject.Inject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class ZhNationalIdentityCardNumberProvider
implements NationalIdentityCardNumberProvider {
    private static final int ORDER_MAX = 9999;
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;

    @Inject
    public ZhNationalIdentityCardNumberProvider(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
        this.dateProducer = new DateProducer(baseProducer, new TimeProvider());
    }

    @Override
    public String get() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(this.baseProducer.randomElement(ZhFairyUtil.PROV_LIST));
        idBuilder.append(ZhFairyUtil.getRandomNumStr(this.baseProducer, 30, 2));
        idBuilder.append(ZhFairyUtil.getRandomNumStr(this.baseProducer, 12, 2));
        idBuilder.append(this.getBirthDate());
        idBuilder.append(ZhFairyUtil.getRandomNumStr(this.baseProducer, 9999, 4));
        return idBuilder.toString();
    }

    private String getBirthDate() {
        LocalDateTime birthDate = this.dateProducer.randomDateInThePast(50);
        return formatter.format(birthDate);
    }
}

