/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class AlphaNumberSystem {
    private static final char[] ALPHABET_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static List<String> generateAlphabetList() {
        ArrayList alphabetList = Lists.newArrayList();
        for (char letter : ALPHABET_CHARS) {
            alphabetList.add(String.valueOf(letter));
        }
        return alphabetList;
    }

    private AlphaNumberSystem() {
    }

    public static String convertToString(int numberToConvert, int base) {
        int number;
        char[] buffer = new char[numberToConvert / ALPHABET_CHARS.length + 1];
        int charPosition = buffer.length - 1;
        if (number == 0) {
            buffer[charPosition--] = ALPHABET_CHARS[number];
        } else {
            for (number = numberToConvert; number > 0; number /= base) {
                buffer[charPosition--] = ALPHABET_CHARS[number % base];
            }
        }
        return new String(buffer, charPosition + 1, buffer.length - charPosition - 1);
    }
}

