/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jpa2ddl;

import com.devskiller.jpa2ddl.Action;
import com.devskiller.jpa2ddl.GenerationMode;
import com.devskiller.jpa2ddl.GeneratorSettings;
import com.devskiller.jpa2ddl.SchemaGenerator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMojo
extends AbstractMojo {
    @Parameter
    private File outputPath;
    @Parameter(required=true)
    private List<String> packages;
    @Parameter
    private Properties jpaProperties;
    @Parameter(defaultValue="true")
    private boolean formatOutput;
    @Parameter(defaultValue="false")
    private boolean skipSequences;
    @Parameter(defaultValue=";")
    private String delimiter;
    @Parameter(defaultValue="CREATE")
    private Action action;
    @Parameter(defaultValue="DATABASE")
    private GenerationMode generationMode;
    @Parameter
    private Properties processorProperties;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor descriptor;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Running schema generation...");
        if (Objects.isNull(this.jpaProperties)) {
            this.jpaProperties = new Properties();
        }
        if (this.outputPath == null) {
            this.outputPath = this.action == Action.UPDATE ? Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("generated-resources/scripts").toFile() : Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("generated-resources/scripts/database.sql").toFile();
        }
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        List compileSourceRoots = this.project.getCompileSourceRoots();
        compileSourceRoots.stream().map(this::mapPathToURL).forEach(url -> this.descriptor.getClassRealm().addURL(url));
        try {
            this.project.getCompileClasspathElements().stream().map(this::mapPathToURL).forEach(url -> this.descriptor.getClassRealm().addURL(url));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException(e);
        }
        GeneratorSettings settings = new GeneratorSettings(this.generationMode, this.outputPath, this.packages, this.action, this.jpaProperties, this.formatOutput, this.delimiter, this.skipSequences, this.processorProperties);
        try {
            schemaGenerator.generate(settings);
            this.getLog().info((CharSequence)("Schema saved to " + this.outputPath));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private URL mapPathToURL(String path) {
        try {
            return Paths.get(path, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    List<String> getPackages() {
        return this.packages;
    }
}

