/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.cache;

import com.dexcoder.commons.cache.AbstractCacheMap;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFUCache<K, V>
extends AbstractCacheMap<K, V> {
    public LFUCache(int cacheSize, long defaultExpire) {
        super(cacheSize, defaultExpire);
        this.cacheMap = new HashMap(cacheSize + 1);
    }

    @Override
    protected int eliminateCache() {
        AbstractCacheMap.CacheObject cacheObject;
        Iterator iterator = this.cacheMap.values().iterator();
        int count = 0;
        long minAccessCount = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            cacheObject = (AbstractCacheMap.CacheObject)iterator.next();
            if (cacheObject.isExpired()) {
                iterator.remove();
                ++count;
                continue;
            }
            minAccessCount = Math.min(cacheObject.accessCount, minAccessCount);
        }
        if (count > 0) {
            return count;
        }
        if (minAccessCount != Long.MAX_VALUE) {
            iterator = this.cacheMap.values().iterator();
            while (iterator.hasNext()) {
                cacheObject = (AbstractCacheMap.CacheObject)iterator.next();
                cacheObject.accessCount -= minAccessCount;
                if (cacheObject.accessCount > 0L) continue;
                iterator.remove();
                ++count;
            }
        }
        return count;
    }
}

