/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.cache;

import com.dexcoder.commons.cache.AbstractCacheMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
extends AbstractCacheMap<K, V> {
    public LRUCache(int cacheSize, long defaultExpire) {
        super(cacheSize, defaultExpire);
        this.cacheMap = new LinkedHashMap<K, AbstractCacheMap.CacheObject<K, V>>(cacheSize + 1, 1.0f, true){
            private static final long serialVersionUID = 4789439462791125917L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, AbstractCacheMap.CacheObject<K, V>> eldest) {
                return LRUCache.this.removeEldestEntry(eldest);
            }
        };
    }

    private boolean removeEldestEntry(Map.Entry<K, AbstractCacheMap.CacheObject<K, V>> eldest) {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.size() > this.cacheSize;
    }

    @Override
    protected int eliminateCache() {
        if (!this.isNeedClearExpiredObject()) {
            return 0;
        }
        Iterator iterator = this.cacheMap.values().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            AbstractCacheMap.CacheObject cacheObject = (AbstractCacheMap.CacheObject)iterator.next();
            if (!cacheObject.isExpired()) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }
}

