/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.interceptor;

import com.dexcoder.commons.exceptions.DexcoderException;
import com.dexcoder.commons.result.RunBinder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public class RunBinderInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RunBinderInterceptor.class);
    private static final long LOG_TIMEOUT = 1000L;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String targetClass = invocation.getThis().getClass().getName();
        String targetMethod = invocation.getMethod().getName();
        long startTime = System.currentTimeMillis();
        LOG.debug("start:[class={},method={},startTime={}]", new Object[]{targetClass, targetMethod, startTime});
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (DexcoderException dexcoderException) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            RunBinder.addError(dexcoderException);
            LOG.info("\u51fa\u73b0\u5df2\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f[resultCode={},resultMsg={}]", (Object)dexcoderException.getResultCode(), (Object)dexcoderException.getResultMsg());
        }
        catch (Throwable throwable) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            RunBinder.addError("UN_KNOWN_EXCEPTION", "\u672a\u77e5\u5f02\u5e38");
            LOG.error("\u53d1\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f", throwable);
        }
        long finishTime = System.currentTimeMillis();
        LOG.debug("finished:[class={},method={},finishTime={}]", new Object[]{targetClass, targetMethod, finishTime});
        long useTime = finishTime - startTime;
        if (useTime > 1000L) {
            LOG.warn("Long processing time:[class={},method={},used time={}]", new Object[]{targetClass, targetMethod, useTime});
        }
        return result;
    }
}

