/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.office;

import com.dexcoder.commons.office.ExcelCell;
import com.dexcoder.commons.office.ExcelRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelSheet {
    private String sheetName;
    private List<String> rowTitles;
    private List<ExcelRow> rows;

    public List<String> getRowTitles() {
        if (!CollectionUtils.isEmpty(this.rowTitles)) {
            return this.rowTitles;
        }
        if (!CollectionUtils.isEmpty(this.rows) && !this.rows.iterator().next().isEmptyRow()) {
            List<ExcelCell> cells = this.rows.get(0).getCells();
            this.rowTitles = new ArrayList<String>(cells.size());
            for (ExcelCell excelCell : cells) {
                this.rowTitles.add(excelCell.getStringValue());
            }
            this.rows.remove(0);
        }
        return this.rowTitles;
    }

    public void setRowTitles(List<String> rowTitles) {
        this.rowTitles = rowTitles;
    }

    public int getTotalRowsNum() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public ExcelRow getRow(int i) {
        return this.rows == null ? null : this.rows.get(i);
    }

    public boolean hasRows() {
        if (this.rows == null) {
            return false;
        }
        boolean result = false;
        Iterator<ExcelRow> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            boolean emptyRow = iterator.next().isEmptyRow();
            if (emptyRow) continue;
            result = true;
        }
        return result;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public List<ExcelRow> getRows() {
        return this.rows;
    }

    public void setRows(List<ExcelRow> rows) {
        this.rows = rows;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("sheetName:").append(this.sheetName);
        sb.append(lineSeparator);
        sb.append("rows:");
        if (this.rows == null) {
            sb.append("null");
        } else {
            sb.append("[").append(lineSeparator);
            for (ExcelRow row : this.rows) {
                sb.append(row == null ? "null" : row.toString());
                sb.append(lineSeparator);
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

