/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.office;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.office.DefaultExcelStyleCreator;
import com.dexcoder.commons.office.ExcelRow;
import com.dexcoder.commons.office.ExcelSheet;
import com.dexcoder.commons.office.ExcelStyleCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelWriteTools {
    public static void addSheet(ExcelSheet excelSheet, File file) {
        ExcelStyleCreator excelStyleCreator = ExcelWriteTools.getExcelStyleCreator();
        ExcelWriteTools.addSheet(excelSheet, file, excelStyleCreator);
    }

    public static void addSheet(ExcelSheet excelSheet, File file, ExcelStyleCreator excelStyleCreator) {
        if (!excelSheet.hasRows()) {
            return;
        }
        FileOutputStream out = null;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            HSSFSheet sheet = excelStyleCreator.createSheet(workbook, excelSheet);
            excelStyleCreator.createTitle(workbook, sheet, excelSheet);
            ExcelWriteTools.createBody(workbook, sheet, excelSheet, excelStyleCreator);
            out = new FileOutputStream(file);
            workbook.write((OutputStream)out);
        }
        catch (Exception e) {
            try {
                throw new CommonsAssistantException("\u6dfb\u52a0\u4e00\u4e2aSheet\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void write(List<ExcelSheet> excelSheetList, File file) {
        ExcelStyleCreator excelStyleCreate = ExcelWriteTools.getExcelStyleCreator();
        ExcelWriteTools.write(excelSheetList, file, excelStyleCreate);
    }

    public static void write(List<ExcelSheet> excelSheetList, File file, ExcelStyleCreator excelStyleCreator) {
        FileOutputStream os = null;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            for (ExcelSheet excelSheet : excelSheetList) {
                if (!excelSheet.hasRows()) continue;
                HSSFSheet sheet = excelStyleCreator.createSheet(workbook, excelSheet);
                excelStyleCreator.createTitle(workbook, sheet, excelSheet);
                ExcelWriteTools.createBody(workbook, sheet, excelSheet, excelStyleCreator);
            }
            os = new FileOutputStream(file);
            workbook.write((OutputStream)os);
        }
        catch (Exception e) {
            try {
                throw new CommonsAssistantException("Excel\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    private static void createBody(HSSFWorkbook workbook, HSSFSheet sheet, ExcelSheet excelSheet, ExcelStyleCreator excelStyleCreator) {
        List<ExcelRow> rows = excelSheet.getRows();
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (int i = 0; i < rows.size(); ++i) {
            ExcelRow excelRow = rows.get(i);
            excelStyleCreator.createRow(workbook, sheet, excelRow, i + 1);
        }
    }

    private static ExcelStyleCreator getExcelStyleCreator() {
        return new DefaultExcelStyleCreator();
    }
}

