/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.commons.utils.UUIDUtils;

public class NameUtils {
    public static String getFirstUpperName(String name) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        String firstChar = StrUtils.substring(name, 0, 1).toUpperCase();
        return firstChar + StrUtils.substring(name, 1);
    }

    public static String getFirstLowerName(String name) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        String firstChar = StrUtils.substring(name, 0, 1).toLowerCase();
        return firstChar + StrUtils.substring(name, 1);
    }

    public static String getCamelName(String name) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        name = StrUtils.lowerCase(name);
        while (StrUtils.startsWith(name, "_")) {
            name = StrUtils.substring(name, 1);
        }
        while (StrUtils.endsWith(name, "_")) {
            name = StrUtils.substring(name, 0, name.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                sb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getUnderlineName(String name) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(c);
        }
        return sb.toString().toUpperCase();
    }

    public static String createUniqueFileName(String fileName) {
        int index = StrUtils.lastIndexOf(fileName, ".");
        String suffix = StrUtils.substring(fileName, index);
        String uqName = UUIDUtils.getUUID16() + suffix;
        return uqName;
    }

    public static String createEndSuffixFileName(String fileName, String endSuffix) {
        int index = StrUtils.lastIndexOf(fileName, ".");
        String preFileName = StrUtils.substring(fileName, 0, index);
        String suffix = StrUtils.substring(fileName, index);
        return preFileName + endSuffix + suffix;
    }
}

