/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.spring;

import com.dexcoder.commons.bean.BeanConverter;
import com.dexcoder.commons.utils.ClassUtils;
import com.dexcoder.commons.utils.NameUtils;
import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.BoundSql;
import com.dexcoder.dal.SqlFactory;
import com.dexcoder.dal.handler.DefaultMappingHandler;
import com.dexcoder.dal.handler.MappingHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJdbcDaoImpl {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected JdbcOperations jdbcTemplate;
    protected MappingHandler mappingHandler;
    protected String rowMapperClass;
    protected SqlFactory sqlFactory;
    protected String dialect;

    protected Long insert(final BoundSql boundSql, final Class<?> clazz) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                String pkColumnName = AbstractJdbcDaoImpl.this.getMappingHandler().getPkColumnName(clazz);
                PreparedStatement ps = con.prepareStatement(boundSql.getSql(), new String[]{pkColumnName});
                int index = 0;
                for (Object param : boundSql.getParameters()) {
                    ps.setObject(++index, param);
                }
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    protected <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        return (T)BeanConverter.mapToBean(map, beanClass);
    }

    protected <T> List<T> mapToBean(List<Map<String, Object>> mapList, Class<T> beanClass) {
        return BeanConverter.mapToBean(mapList, beanClass);
    }

    protected Map<String, Object> convertMapKeyToCamel(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String camelName = StrUtils.indexOf((String)entry.getKey(), (String)"_") != -1 ? NameUtils.getCamelName((String)entry.getKey()) : entry.getKey().toLowerCase();
            resultMap.put(camelName, entry.getValue());
        }
        return resultMap;
    }

    protected List<Map<String, Object>> convertMapKeyToCamel(List<Map<String, Object>> mapList) {
        if (mapList == null) {
            return null;
        }
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>(mapList.size());
        for (Map<String, Object> map : mapList) {
            Map<String, Object> resultMap = this.convertMapKeyToCamel(map);
            resultMapList.add(resultMap);
        }
        return resultMapList;
    }

    protected <T> RowMapper<T> getRowMapper(Class<T> clazz) {
        if (StrUtils.isBlank((String)this.rowMapperClass)) {
            return BeanPropertyRowMapper.newInstance(clazz);
        }
        return (RowMapper)ClassUtils.newInstance((String)this.rowMapperClass);
    }

    protected MappingHandler getMappingHandler() {
        if (this.mappingHandler == null) {
            this.mappingHandler = new DefaultMappingHandler();
        }
        return this.mappingHandler;
    }

    protected String getDialect() {
        if (StrUtils.isBlank((String)this.dialect)) {
            this.dialect = (String)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

                public String doInConnection(Connection con) throws SQLException, DataAccessException {
                    return con.getMetaData().getDatabaseProductName().toUpperCase();
                }
            });
        }
        return this.dialect;
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setMappingHandler(MappingHandler mappingHandler) {
        this.mappingHandler = mappingHandler;
    }

    public void setRowMapperClass(String rowMapperClass) {
        this.rowMapperClass = rowMapperClass;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setSqlFactory(SqlFactory sqlFactory) {
        this.sqlFactory = sqlFactory;
    }
}

