/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.spring.datasource;

import com.dexcoder.commons.utils.ClassUtils;
import com.dexcoder.commons.utils.PropertyUtils;
import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.exceptions.JdbcAssistantException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDataSourceUtils {
    public static void addWeightDataSource(List<String> readDsList, List<String> writeDsList, String dsId, int weight, String mode) {
        if (StrUtils.equalsIgnoreCase((String)mode, (String)"r")) {
            for (int i = 0; i < weight; ++i) {
                readDsList.add(dsId);
            }
        } else if (StrUtils.equalsIgnoreCase((String)mode, (String)"w")) {
            for (int i = 0; i < weight; ++i) {
                writeDsList.add(dsId);
            }
        } else if (StrUtils.equalsIgnoreCase((String)mode, (String)"rw")) {
            for (int i = 0; i < weight; ++i) {
                readDsList.add(dsId);
                writeDsList.add(dsId);
            }
        } else {
            throw new JdbcAssistantException("\u52a8\u6001\u6570\u636e\u6e90\u8bfb\u5199\u6a21\u5f0f\u8bbe\u7f6e\u9519\u8bef,\u5e94\u4e3a\u5176\u4e2d\u4e00\u79cd:[mode=r,mode=w,mode=rw]");
        }
    }

    public static void setDsProperties(Map<String, String> map, DataSource dataSource) {
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            PropertyDescriptor propertyDescriptor = ClassUtils.getPropertyDescriptor(dataSource.getClass(), (String)name);
            if (propertyDescriptor == null || propertyDescriptor.getWriteMethod() == null) continue;
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(true);
            }
            Object value = ClassUtils.toTargetTypeValue((Object)entry.getValue(), propertyDescriptor.getPropertyType());
            ClassUtils.invokeMethod((Method)writeMethod, (Object)dataSource, (Object)value);
        }
    }

    public static String getAndRemoveValue(Map<String, String> map, String key, String defaultValue) {
        String value = map.get(key);
        map.remove(key);
        if (StrUtils.isBlank((String)value) && StrUtils.isBlank((String)defaultValue)) {
            throw new JdbcAssistantException("\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a:" + key);
        }
        return StrUtils.isBlank((String)value) ? defaultValue : value;
    }

    public static List<Map<String, String>> parseDataSources(String dsConfigFile) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(PropertyUtils.loadResource((String)dsConfigFile));
            Element dataSources = doc.getDocumentElement();
            NodeList datasourceNodes = dataSources.getChildNodes();
            if (datasourceNodes == null || datasourceNodes.getLength() == 0) {
                throw new JdbcAssistantException("\u52a8\u6001\u6570\u636e\u6e90\u914d\u7f6e\u4fe1\u606f\u9519\u8bef");
            }
            ArrayList<Map<String, String>> dataSourceList = new ArrayList<Map<String, String>>(10);
            for (int i = 0; i < datasourceNodes.getLength(); ++i) {
                Node node = datasourceNodes.item(i);
                if (node.getNodeType() != 1) continue;
                String dataSourceId = DynamicDataSourceUtils.getAttr(node, "id");
                String dataSourceClass = DynamicDataSourceUtils.getAttr(node, "class");
                String isDefaultDataSource = DynamicDataSourceUtils.getAttr(node, "default");
                NodeList propertyNodeList = node.getChildNodes();
                Map<String, String> proMap = DynamicDataSourceUtils.parseProperties(propertyNodeList);
                proMap.put("id", dataSourceId);
                proMap.put("class", dataSourceClass);
                proMap.put("default", isDefaultDataSource);
                dataSourceList.add(proMap);
            }
            return dataSourceList;
        }
        catch (Exception e) {
            throw new JdbcAssistantException("\u89e3\u6790\u52a8\u6001\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6\u51fa\u9519:" + dsConfigFile, (Throwable)e);
        }
    }

    private static String getAttr(Node node, String attrName) {
        NamedNodeMap attributes = node.getAttributes();
        Node namedItem = attributes.getNamedItem(attrName);
        if (namedItem == null) {
            return null;
        }
        return namedItem.getNodeValue();
    }

    private static Map<String, String> parseProperties(NodeList propertyNodeList) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (propertyNodeList == null || propertyNodeList.getLength() == 0) {
            return propertyMap;
        }
        for (int i = 0; i < propertyNodeList.getLength(); ++i) {
            Node node = propertyNodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap attributes = node.getAttributes();
            String name = attributes.getNamedItem("name").getNodeValue();
            String value = attributes.getNamedItem("value").getNodeValue();
            propertyMap.put(name, value);
        }
        return propertyMap;
    }
}

