/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.spring.datasource;

import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.spring.datasource.DynamicDataSourceHolder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DynamicDsInterceptor {
    @Pointcut(value="execution(* org.springframework.jdbc.core.JdbcOperations.*(..))")
    public void executeMethod() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5");
    }

    @Around(value="executeMethod()")
    public Object methodAspect(ProceedingJoinPoint pjp) throws Throwable {
        String methodName = pjp.getSignature().getName();
        if (StrUtils.startsWith((String)methodName, (String)"query")) {
            DynamicDataSourceHolder.setIsWrite(false);
        } else {
            DynamicDataSourceHolder.setIsWrite(true);
        }
        return pjp.proceed();
    }
}

