/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.dal.BoundSql;
import com.dexcoder.dal.build.AbstractSqlBuilder;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.build.AutoFieldType;
import com.dexcoder.dal.build.CriteriaBoundSql;
import com.dexcoder.dal.build.MetaTable;
import com.dexcoder.dal.exceptions.JdbcAssistantException;
import com.dexcoder.dal.handler.MappingHandler;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByBuilder
extends AbstractSqlBuilder {
    protected static final String COMMAND_OPEN = " ORDER BY ";

    public OrderByBuilder(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public void addField(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        AutoField autoField = new AutoField.Builder().name(fieldName).fieldOperator(fieldOperator).type(type).build();
        this.metaTable.getAutoFields().put(fieldName, autoField);
    }

    @Override
    public void addCondition(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        throw new JdbcAssistantException("OrderByBuilder\u4e0d\u652f\u6301\u8bbe\u7f6e\u6761\u4ef6");
    }

    @Override
    public BoundSql build(Object entity, boolean isIgnoreNull, MappingHandler mappingHandler) {
        this.metaTable = new MetaTable.Builder(this.metaTable).mappingHandler(mappingHandler).build();
        StringBuilder sb = new StringBuilder(COMMAND_OPEN);
        if (this.metaTable.getAutoFields().isEmpty()) {
            sb.append(this.metaTable.applyColumnTableAlias(this.metaTable.getPkColumnName())).append(" DESC");
        } else {
            for (Map.Entry<String, AutoField> entry : this.metaTable.getAutoFields().entrySet()) {
                String columnName = this.metaTable.getColumnAndTableAliasName(entry.getValue());
                sb.append(columnName).append(" ").append(entry.getValue().getFieldOperator()).append(",");
            }
            if (sb.length() > 10) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return new CriteriaBoundSql(sb.toString(), null);
    }
}

